/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.rdbms.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.DataSourceValidator;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.RDBMSDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.StringResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.TemplatedExecutableStatementBuilder;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ManagedConnectionParser;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RDBMSDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "RelationalDatabase");
    @Nonnull
    public static final QName ATTRIBUTE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "Attribute");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RDBMSDataConnectorParser.class);

    protected Class<RDBMSDataConnector> getNativeBeanClass() {
        return RDBMSDataConnector.class;
    }

    @Override
    protected void doV2Parse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String mappingStrategyID;
        this.log.debug("{} Parsing v2 configuration {}", (Object)this.getLogPrefix(), (Object)config);
        V2Parser v2Parser = new V2Parser(config);
        String dataSourceID = v2Parser.getBeanDataSourceID();
        BeanDefinition dataSource = null;
        if (dataSourceID != null) {
            builder.addPropertyReference("DataSource", dataSourceID);
        } else {
            dataSource = v2Parser.createManagedDataSource();
            builder.addPropertyValue("DataSource", (Object)v2Parser.createManagedDataSource());
        }
        builder.addPropertyValue("executableSearchBuilder", (Object)v2Parser.createTemplateBuilder());
        String connectionReadOnly = v2Parser.getConnectionReadOnly();
        if (connectionReadOnly != null) {
            builder.addPropertyValue("connectionReadOnly", (Object)connectionReadOnly);
        }
        if ((mappingStrategyID = v2Parser.getBeanMappingStrategyID()) != null) {
            builder.addPropertyReference("mappingStrategy", mappingStrategyID);
        } else {
            BeanDefinition def = v2Parser.createMappingStrategy();
            if (def != null) {
                builder.addPropertyValue("mappingStrategy", (Object)def);
            }
        }
        String validatorID = v2Parser.getBeanValidatorID();
        if (validatorID != null) {
            builder.addPropertyReference("validator", validatorID);
        } else if (dataSourceID != null) {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator(dataSourceID));
        } else {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator(dataSource));
        }
        String resultCacheID = v2Parser.getBeanResultCacheID();
        if (resultCacheID != null) {
            builder.addPropertyReference("resultsCache", resultCacheID);
        } else {
            builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache());
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected static class V2Parser {
        private final Element configElement;
        private final Logger log = LoggerFactory.getLogger(V2Parser.class);

        public V2Parser(@Nonnull Element config) {
            Constraint.isNotNull((Object)config, (String)"RelationalDatabase element cannot be null");
            this.configElement = config;
            if (AttributeSupport.hasAttribute((Element)config, (QName)new QName("queryUsesStoredProcedure"))) {
                this.log.warn("queryUsesStoredProcedure property no longer supported and should be removed");
            }
        }

        @Nonnull
        public BeanDefinition createManagedDataSource() {
            ManagedConnectionParser parser = new ManagedConnectionParser(this.configElement);
            return parser.createDataSource();
        }

        @Nullable
        public String getConnectionReadOnly() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("readOnlyConnection"));
        }

        @Nullable
        public String getBeanDataSourceID() {
            Element el = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "BeanManagedConnection"));
            if (el != null) {
                return ElementSupport.getElementContentAsString((Element)el);
            }
            return null;
        }

        @Nonnull
        public BeanDefinition createTemplateBuilder() {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedExecutableStatementBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttribute("templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            templateBuilder.addPropertyValue("v2Compatibility", (Object)true);
            String queryTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("queryTimeout"));
            if (queryTimeout != null) {
                BeanDefinitionBuilder duration = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                duration.addConstructorArgValue((Object)queryTimeout);
                duration.addConstructorArgValue((Object)1);
                templateBuilder.addPropertyValue("queryTimeout", (Object)duration.getBeanDefinition());
            }
            Element queryTemplate = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "QueryTemplate"));
            String queryText = queryTemplate.getTextContent();
            templateBuilder.addPropertyValue("templateText", (Object)queryText);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            return templateBuilder.getBeanDefinition();
        }

        @Nullable
        public String getBeanMappingStrategyID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"mappingStrategyRef");
        }

        @Nullable
        public BeanDefinition createMappingStrategy() {
            String multipleResultsIsError;
            String noResultIsError;
            BeanDefinitionBuilder mapper = BeanDefinitionBuilder.genericBeanDefinition(StringResultMappingStrategy.class);
            List columns = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver:dc", (String)"Column");
            if (!columns.isEmpty()) {
                ManagedMap renamingMap = new ManagedMap();
                for (Element column : columns) {
                    String columnName = AttributeSupport.getAttributeValue((Element)column, null, (String)"columnName");
                    String attributeId = AttributeSupport.getAttributeValue((Element)column, null, (String)"attributeID");
                    if (columnName != null && attributeId != null) {
                        renamingMap.put((Object)columnName, (Object)attributeId);
                    }
                    if (!AttributeSupport.hasAttribute((Element)column, (QName)new QName("type"))) continue;
                    LoggerFactory.getLogger(RDBMSDataConnectorParser.class).warn("dc:Column type attribute is no longer supported");
                }
                mapper.addPropertyValue("resultRenamingMap", (Object)renamingMap);
            }
            if ((noResultIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("noResultIsError"))) != null) {
                mapper.addPropertyValue("noResultAnError", (Object)noResultIsError);
            }
            if ((multipleResultsIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("multipleResultsIsError"))) != null) {
                mapper.addPropertyValue("multipleResultsAnError", (Object)multipleResultsIsError);
            }
            return mapper.getBeanDefinition();
        }

        @Nullable
        public String getBeanValidatorID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"validatorRef");
        }

        @Nullable
        public BeanDefinition createValidator(Object dataSource) {
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.genericBeanDefinition(DataSourceValidator.class);
            if (dataSource instanceof String) {
                validator.addConstructorArgReference((String)dataSource);
            } else {
                validator.addConstructorArgValue(dataSource);
            }
            validator.addConstructorArgValue((Object)true);
            return validator.getBeanDefinition();
        }

        @Nullable
        public String getBeanResultCacheID() {
            Element el = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ResultCacheBean"));
            if (el != null) {
                return ElementSupport.getElementContentAsString((Element)el);
            }
            return null;
        }

        @Nullable
        public BeanDefinition createCache() {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache();
        }

        public static long buildDuration(String duration, long divisor) {
            return DOMTypeSupport.durationToLong((String)duration) / divisor;
        }
    }
}

