/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.factory.EvaluableScriptFactoryBean;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScriptedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScriptedAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME_AD = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Script");
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ScriptedAttribute");
    @Nonnull
    public static final QName SCRIPT_FILE_ELEMENT_NAME_AD = new QName("urn:mace:shibboleth:2.0:resolver:ad", "ScriptFile");
    @Nonnull
    public static final QName SCRIPT_ELEMENT_NAME_AD = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Script");
    @Nonnull
    public static final QName SCRIPT_FILE_ELEMENT_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ScriptFile");
    @Nonnull
    public static final QName SCRIPT_ELEMENT_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "Script");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedAttributeDefinitionParser.class);

    protected Class<ScriptedAttributeDefinition> getBeanClass(@Nullable Element element) {
        return ScriptedAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        BeanDefinitionBuilder scriptBuilder = BeanDefinitionBuilder.genericBeanDefinition(EvaluableScriptFactoryBean.class);
        scriptBuilder.addPropertyValue("sourceId", (Object)this.getLogPrefix());
        if (config.hasAttributeNS(null, "language")) {
            String scriptLanguage = StringSupport.trimOrNull((String)config.getAttributeNS(null, "language"));
            this.log.debug("{} Scripting language: {}", (Object)this.getLogPrefix(), (Object)scriptLanguage);
            scriptBuilder.addPropertyValue("engineName", (Object)scriptLanguage);
        }
        List scriptElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_ELEMENT_NAME_AD);
        scriptElem.addAll(ElementSupport.getChildElements((Node)config, (QName)SCRIPT_ELEMENT_NAME_RESOLVER));
        List scriptFileElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_FILE_ELEMENT_NAME_AD);
        scriptFileElem.addAll(ElementSupport.getChildElements((Node)config, (QName)SCRIPT_FILE_ELEMENT_NAME_RESOLVER));
        if (scriptElem != null && scriptElem.size() > 0) {
            if (scriptFileElem != null && scriptFileElem.size() > 0) {
                this.log.warn("{} Attribute definition {}: definition contains both <Script> and <ScriptFile> elements, taking the <Script> element", (Object)this.getLogPrefix(), (Object)this.getDefinitionId());
            }
            String script = ((Element)scriptElem.get(0)).getTextContent();
            this.log.debug("{} Script: {}", (Object)this.getLogPrefix(), (Object)script);
            scriptBuilder.addPropertyValue("script", (Object)script);
        } else if (scriptFileElem != null && scriptFileElem.size() > 0) {
            String scriptFile = ((Element)scriptFileElem.get(0)).getTextContent();
            this.log.debug("{} Script file: {}", (Object)this.getLogPrefix(), (Object)scriptFile);
            scriptBuilder.addPropertyValue("resource", (Object)scriptFile);
        } else {
            this.log.error("{} No script or script file specified for this attribute definition", (Object)this.getLogPrefix());
            throw new BeanCreationException("No script or script file specified for this attribute definition");
        }
        String customRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "customObjectRef"));
        if (null != customRef) {
            builder.addPropertyReference("customObject", customRef);
        }
        builder.addPropertyValue("script", (Object)scriptBuilder.getBeanDefinition());
    }

    @Override
    protected boolean needsAttributeSourceID() {
        return false;
    }
}

