/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.DataConnectorFactoryBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDataConnectorParser
extends BaseResolverPluginParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "DataConnector");
    @Nonnull
    @NotEmpty
    public static final String ATTR_NORETRYDELAY = "noRetryDelay";
    @Nonnull
    @NotEmpty
    public static final String ATTR_SPRING_RESOURCE = "springResources";
    @Nonnull
    @NotEmpty
    public static final String ATTR_SPRING_RESOURCE_REF = "springResourcesRef";
    @Nonnull
    @NotEmpty
    public static final String ATTR_FACTORY_POSTPROCESSORS_REF = "factoryPostProcessorsRef";
    @Nonnull
    @NotEmpty
    public static final String ATTR_POSTPROCESSORS_REF = "postProcessorsRef";
    @Nonnull
    public static final QName FAILOVER_DATA_CONNECTOR_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "FailoverDataConnector");
    private static boolean warned;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDataConnectorParser.class);

    protected boolean isNative(@Nonnull Element config) {
        return config.hasAttributeNS(null, ATTR_SPRING_RESOURCE) || config.hasAttributeNS(null, ATTR_SPRING_RESOURCE_REF);
    }

    protected final Class<?> getBeanClass(Element element) {
        if (this.isNative(element)) {
            return DataConnectorFactoryBean.class;
        }
        return this.getNativeBeanClass();
    }

    protected abstract Class<? extends AbstractDataConnector> getNativeBeanClass();

    @Override
    protected final void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        List failoverConnector;
        super.doParse(config, parserContext, builder);
        QName suppliedQname = DOMTypeSupport.getXSIType((Element)config);
        if (!"urn:mace:shibboleth:2.0:resolver".equals(suppliedQname.getNamespaceURI())) {
            if (!warned) {
                warned = true;
                this.log.warn("{} Configuration contains at least one element in the deprecated '{}' namespace.", (Object)this.getLogPrefix(), (Object)"urn:mace:shibboleth:2.0:resolver:dc");
            }
            if (this.log.isDebugEnabled()) {
                QName otherQname = new QName("urn:mace:shibboleth:2.0:resolver:dc", suppliedQname.getLocalPart(), "dc:");
                this.log.debug("{} Deprecated Namespace element '{}' in {}, consider using '{}'", new Object[]{this.getLogPrefix(), suppliedQname.toString(), parserContext.getReaderContext().getResource().getDescription(), otherQname.toString()});
            }
        }
        if ((failoverConnector = ElementSupport.getChildElements((Node)config, (QName)FAILOVER_DATA_CONNECTOR_ELEMENT_NAME)) != null && !failoverConnector.isEmpty()) {
            if (failoverConnector.size() > 1) {
                this.log.warn("{} More than one failover data connector specified, taking the first", (Object)this.getLogPrefix());
            }
            String connectorId = StringSupport.trimOrNull((String)((Element)failoverConnector.get(0)).getAttributeNS(null, "ref"));
            this.log.debug("{} Setting the following failover data connector dependencies: {}", (Object)this.getLogPrefix(), (Object)connectorId);
            builder.addPropertyValue("failoverDataConnectorId", (Object)connectorId);
        }
        if (config.hasAttributeNS(null, ATTR_NORETRYDELAY)) {
            String noRetryDelay = StringSupport.trimOrNull((String)config.getAttributeNS(null, ATTR_NORETRYDELAY));
            BeanDefinitionBuilder duration = BeanDefinitionBuilder.rootBeanDefinition(AbstractDataConnectorParser.class, (String)"buildDuration");
            duration.addConstructorArgValue((Object)noRetryDelay);
            duration.addConstructorArgValue((Object)1);
            builder.addPropertyValue(ATTR_NORETRYDELAY, (Object)duration.getBeanDefinition());
        }
        if (this.isNative(config)) {
            builder.addPropertyValue("objectType", this.getNativeBeanClass());
            builder.setInitMethodName(null);
            builder.setDestroyMethodName(null);
            if (config.hasAttributeNS(null, ATTR_SPRING_RESOURCE)) {
                String[] resources = StringSupport.trimOrNull((String)config.getAttributeNS(null, ATTR_SPRING_RESOURCE)).split(";");
                this.log.debug("{} Native configuration from {}", (Object)this.getLogPrefix(), (Object)resources);
                builder.addPropertyValue("resources", (Object)resources);
            } else {
                String resourceRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, ATTR_SPRING_RESOURCE_REF));
                this.log.debug("{} Native configuration from bean {}", (Object)this.getLogPrefix(), (Object)resourceRef);
                builder.addPropertyReference("resources", resourceRef);
            }
            if (config.hasAttributeNS(null, ATTR_FACTORY_POSTPROCESSORS_REF)) {
                String factoryPostProcessorsRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, ATTR_FACTORY_POSTPROCESSORS_REF));
                this.log.debug("{} Factory Bean Post Processors {}", (Object)this.getLogPrefix(), (Object)factoryPostProcessorsRef);
                builder.addPropertyReference("beanFactoryPostProcessors", factoryPostProcessorsRef);
            } else {
                this.log.debug("{} Adding default Factory Bean Post Processor: shibboleth.PropertySourcesPlaceholderConfigurer", (Object)this.getLogPrefix());
                builder.addPropertyReference("beanFactoryPostProcessors", "shibboleth.PropertySourcesPlaceholderConfigurer");
            }
            if (config.hasAttributeNS(null, ATTR_POSTPROCESSORS_REF)) {
                String postProcessorsRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, ATTR_POSTPROCESSORS_REF));
                this.log.debug("{} Bean Post Processors {}", (Object)this.getLogPrefix(), (Object)postProcessorsRef);
                builder.addPropertyReference("beanPostProcessors", postProcessorsRef);
            }
        } else {
            this.doV2Parse(config, parserContext, builder);
        }
    }

    protected abstract void doV2Parse(Element var1, ParserContext var2, BeanDefinitionBuilder var3);

    public static long buildDuration(String duration, long divisor) {
        return DOMTypeSupport.durationToLong((String)duration) / divisor;
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Data Connector '").append(this.getDefinitionId()).append("':");
        return builder.toString();
    }
}

