/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.saml.nameid.impl.ComputedPersistentIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseComputedIDDataConnectorParser
extends BaseResolverPluginParser {
    private static boolean warned;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseComputedIDDataConnectorParser.class);

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder, @Nullable String generatedIdDefaultName) {
        String enc;
        super.doParse(config, parserContext, builder);
        QName suppliedQname = DOMTypeSupport.getXSIType((Element)config);
        if (!"urn:mace:shibboleth:2.0:resolver".equals(suppliedQname.getNamespaceURI())) {
            if (!warned) {
                warned = true;
                this.log.warn("{} Configuration contains at least one element in the deprecated '{}' namespace.", (Object)this.getLogPrefix(), (Object)"urn:mace:shibboleth:2.0:resolver:dc");
            }
            if (this.log.isDebugEnabled()) {
                QName otherQname = new QName("urn:mace:shibboleth:2.0:resolver:dc", suppliedQname.getLocalPart(), "dc:");
                this.log.debug("{} Deprecated Namespace element '{}' in {}, consider using' {}'", new Object[]{this.getLogPrefix(), suppliedQname.toString(), parserContext.getReaderContext().getResource().getDescription(), otherQname.toString()});
            }
        }
        ComputedPersistentIdGenerationStrategy.Encoding encoding = ComputedPersistentIdGenerationStrategy.Encoding.BASE64;
        if (config.hasAttributeNS(null, "encoding") && (enc = StringSupport.trimOrNull((String)config.getAttributeNS(null, "encoding"))) != null) {
            if ("BASE32".equals(enc)) {
                encoding = ComputedPersistentIdGenerationStrategy.Encoding.BASE32;
            } else if (!"BASE64".equals(enc)) {
                this.log.warn("{} Ignoring unknown encoding value '{}'", (Object)this.getLogPrefix(), (Object)enc);
            }
        }
        String generatedAttribute = config.hasAttributeNS(null, "generatedAttributeID") ? StringSupport.trimOrNull((String)config.getAttributeNS(null, "generatedAttributeID")) : generatedIdDefaultName;
        List failoverConnector = ElementSupport.getChildElements((Node)config, (QName)AbstractDataConnectorParser.FAILOVER_DATA_CONNECTOR_ELEMENT_NAME);
        if (failoverConnector != null && !failoverConnector.isEmpty()) {
            if (failoverConnector.size() > 1) {
                this.log.warn("{} More than one failover data connector specified, taking the first", (Object)this.getLogPrefix());
            }
            String connectorId = StringSupport.trimOrNull((String)((Element)failoverConnector.get(0)).getAttributeNS(null, "ref"));
            this.log.debug("{} Setting the following failover data connector dependencies: {}", (Object)this.getLogPrefix(), (Object)connectorId);
            builder.addPropertyValue("failoverDataConnectorId", (Object)connectorId);
        }
        String sourceAttribute = StringSupport.trimOrNull((String)config.getAttributeNS(null, "sourceAttributeID"));
        String salt = AttributeSupport.hasAttribute((Element)config, (QName)new QName("salt")) ? config.getAttributeNS(null, "salt") : null;
        if (null == salt) {
            this.log.debug("{} Generated Attribute: '{}', sourceAttribute = '{}', no salt provided", new Object[]{this.getLogPrefix(), generatedAttribute, sourceAttribute});
        } else {
            this.log.debug("{} Generated Attribute: '{}', sourceAttribute = '{}', see TRACE log for its value", new Object[]{this.getLogPrefix(), generatedAttribute, sourceAttribute});
            this.log.trace("{} salt: '{}'", (Object)this.getLogPrefix(), (Object)salt);
        }
        builder.addPropertyValue("generatedAttributeId", (Object)generatedAttribute);
        builder.addPropertyValue("sourceAttributeId", (Object)sourceAttribute);
        builder.addPropertyValue("salt", (Object)salt);
        builder.addPropertyValue("encoding", (Object)encoding);
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Data Connector '").append(this.getDefinitionId()).append("':");
        return builder.toString();
    }
}

