/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.factory.EvaluableScriptFactoryBean;
import net.shibboleth.idp.attribute.resolver.dc.impl.ScriptedDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.ScriptedAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScriptDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "Script");
    @Nonnull
    public static final QName TYPE_NAME_RESVOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ScriptedDataConnector");
    @Nonnull
    public static final QName SCRIPT_FILE_ELEMENT_NAME_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "ScriptFile");
    @Nonnull
    public static final QName SCRIPT_FILE_ELEMENT_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ScriptFile");
    @Nonnull
    public static final QName SCRIPT_ELEMENT_NAME_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "Script");
    @Nonnull
    public static final QName SCRIPT_ELEMENT_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "Script");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedAttributeDefinitionParser.class);

    protected Class<ScriptedDataConnector> getNativeBeanClass() {
        return ScriptedDataConnector.class;
    }

    @Override
    protected void doV2Parse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder scriptBuilder = BeanDefinitionBuilder.genericBeanDefinition(EvaluableScriptFactoryBean.class);
        scriptBuilder.addPropertyValue("sourceId", (Object)this.getLogPrefix());
        if (config.hasAttributeNS(null, "language")) {
            String scriptLanguage = StringSupport.trimOrNull((String)config.getAttributeNS(null, "language"));
            this.log.debug("{} Scripting language: {}", (Object)this.getLogPrefix(), (Object)scriptLanguage);
            scriptBuilder.addPropertyValue("engineName", (Object)scriptLanguage);
        }
        List scriptElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_ELEMENT_NAME_DC);
        scriptElem.addAll(ElementSupport.getChildElements((Node)config, (QName)SCRIPT_ELEMENT_NAME_RESOLVER));
        List scriptFileElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_FILE_ELEMENT_NAME_DC);
        scriptFileElem.addAll(ElementSupport.getChildElements((Node)config, (QName)SCRIPT_FILE_ELEMENT_NAME_RESOLVER));
        if (scriptElem != null && scriptElem.size() > 0) {
            if (scriptElem.size() > 1) {
                this.log.warn("{} Data connector {}: definition contains more than one  <Script> elements, only the first will be used", (Object)this.getLogPrefix(), (Object)this.getDefinitionId());
            }
            if (scriptFileElem != null && scriptFileElem.size() > 0) {
                this.log.warn("{} Data connector {}: definition contains both <Script> and <ScriptFile> elements, taking the <Script> element", (Object)this.getLogPrefix(), (Object)this.getDefinitionId());
            }
            String script = ((Element)scriptElem.get(0)).getTextContent();
            this.log.debug("{} Script: {}", (Object)this.getLogPrefix(), (Object)script);
            scriptBuilder.addPropertyValue("script", (Object)script);
        } else if (scriptFileElem != null && scriptFileElem.size() > 0) {
            if (scriptFileElem.size() > 1) {
                this.log.warn("{} Data connector {}: definition contains more than one  <ScriptFile> elements, only the first will be used", (Object)this.getLogPrefix(), (Object)this.getDefinitionId());
            }
            String scriptFile = ((Element)scriptFileElem.get(0)).getTextContent();
            this.log.debug("{} Script file: {}", (Object)this.getLogPrefix(), (Object)scriptFile);
            scriptBuilder.addPropertyValue("resource", (Object)scriptFile);
        } else {
            this.log.error("{} No script or script file specified for this data connector", (Object)this.getLogPrefix());
            throw new BeanCreationException("No script or script file specified for this attribute definition");
        }
        String customRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "customObjectRef"));
        if (null != customRef) {
            builder.addPropertyReference("customObject", customRef);
        }
        builder.addPropertyValue("script", (Object)scriptBuilder.getBeanDefinition());
    }
}

