/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.enc.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.enc.BaseAttributeEncoderParser;
import net.shibboleth.idp.saml.attribute.encoding.impl.SAML2ByteAttributeEncoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SAML2Base64AttributeEncoderParser
extends BaseAttributeEncoderParser {
    @Nonnull
    public static final QName TYPE_NAME_ENC = new QName("urn:mace:shibboleth:2.0:attribute:encoder", "SAML2Base64");
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "SAML2Base64");
    @Nonnull
    @NotEmpty
    public static final String NAME_FORMAT_ATTRIBUTE_NAME = "nameFormat";
    @Nonnull
    @NotEmpty
    public static final String FRIENDLY_NAME_ATTRIBUTE_NAME = "friendlyName";

    public SAML2Base64AttributeEncoderParser() {
        this.setNameRequired(true);
    }

    protected Class<SAML2ByteAttributeEncoder> getBeanClass(@Nullable Element element) {
        return SAML2ByteAttributeEncoder.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        if (config.hasAttributeNS(null, NAME_FORMAT_ATTRIBUTE_NAME)) {
            String nameFormat = StringSupport.trimOrNull((String)config.getAttributeNS(null, NAME_FORMAT_ATTRIBUTE_NAME));
            builder.addPropertyValue(NAME_FORMAT_ATTRIBUTE_NAME, (Object)nameFormat);
        }
        builder.addPropertyValue(FRIENDLY_NAME_ATTRIBUTE_NAME, (Object)config.getAttributeNS(null, FRIENDLY_NAME_ATTRIBUTE_NAME));
    }
}

