/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.spring.ResolverPluginDependencyParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InputDataConnectorParser
extends ResolverPluginDependencyParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "InputDataConnector");
    @Nonnull
    @Deprecated
    public static final QName SOURCE_ATTRIBUTES = new QName("urn:mace:shibboleth:2.0:resolver", "SourceAttribute");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InputDataConnectorParser.class);

    protected Class<ResolverDataConnectorDependency> getBeanClass(@Nullable Element element) {
        return ResolverDataConnectorDependency.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        Attr attributes = config.getAttributeNodeNS(null, "attributeNames");
        String allAttributes = StringSupport.trimOrNull((String)config.getAttributeNS(null, "allAttributes"));
        List attributeElements = ElementSupport.getChildElements((Node)config, (QName)SOURCE_ATTRIBUTES);
        if (attributes != null) {
            if (allAttributes != null) {
                this.log.error("attributeNames and allAttributes are mutually exclusive");
                throw new BeanCreationException(ELEMENT_NAME.getLocalPart() + ": attributeNames and allAttributes are mutually exclusive");
            }
            if (!attributeElements.isEmpty()) {
                this.log.error("attributeNames and <SourceAttribute> are mutually exclusive");
                throw new BeanCreationException(ELEMENT_NAME.getLocalPart() + ": attributeNames and child elements are mutually exclusive");
            }
            builder.addPropertyValue("attributeNames", (Object)SpringSupport.getAttributeValueAsList((Attr)attributes));
        } else if (allAttributes != null) {
            if (!attributeElements.isEmpty()) {
                this.log.error("allAttributes and <SourceAttribute> are mutually exclusive");
                throw new BeanCreationException(ELEMENT_NAME.getLocalPart() + ": attributeNames and allAttributes are mutually exclusive");
            }
            builder.addPropertyValue("allAttributes", (Object)allAttributes);
        } else if (!attributeElements.isEmpty()) {
            ManagedList elementNameList = new ManagedList(attributeElements.size());
            for (Element el : attributeElements) {
                elementNameList.add((Object)el.getTextContent());
            }
            builder.addPropertyValue("attributeNames", (Object)elementNameList);
        } else {
            this.log.error("One of attributeNames, allAttributes or <SourceAttribute>  must be specified");
            throw new BeanCreationException(ELEMENT_NAME.getLocalPart() + ": One of attributeNames, allAttributes or <SourceAttribute> must be specified ");
        }
    }
}

