/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.idp.attribute.resolver.spring.impl.InputAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.impl.InputDataConnectorParser;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseAttributeDefinitionParser
extends BaseResolverPluginParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "AttributeDefinition");
    @Nonnull
    public static final QName ATTRIBUTE_ENCODER_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "AttributeEncoder");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseAttributeDefinitionParser.class);

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        List attributeEncoders;
        List displayDescriptions;
        super.doParse(config, parserContext, builder);
        List displayNames = ElementSupport.getChildElements((Node)config, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "DisplayName"));
        if (displayNames != null && !displayNames.isEmpty()) {
            Map<Locale, String> names = this.processLocalizedElement(displayNames);
            this.log.debug("{} Setting displayNames {}", (Object)this.getLogPrefix(), names);
            builder.addPropertyValue("displayNames", names);
        }
        if ((displayDescriptions = ElementSupport.getChildElements((Node)config, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "DisplayDescription"))) != null && !displayDescriptions.isEmpty()) {
            Map<Locale, String> names = this.processLocalizedElement(displayDescriptions);
            this.log.debug("{} Setting displayDescriptions {}", (Object)this.getLogPrefix(), names);
            builder.addPropertyValue("displayDescriptions", names);
        }
        if (config.hasAttributeNS(null, "dependencyOnly")) {
            String dependencyOnly = StringSupport.trimOrNull((String)config.getAttributeNS(null, "dependencyOnly"));
            this.log.debug("{} Setting dependencyOnly {}", (Object)this.getLogPrefix(), (Object)dependencyOnly);
            builder.addPropertyValue("dependencyOnly", (Object)dependencyOnly);
        }
        if (config.hasAttributeNS(null, "sourceAttributeID")) {
            String sourceAttributeId = config.getAttributeNodeNS(null, "sourceAttributeID").getValue();
            this.log.debug("{} Setting sourceAttributeID {}", (Object)this.getLogPrefix(), (Object)sourceAttributeId);
            builder.addPropertyValue("sourceAttributeId", (Object)sourceAttributeId);
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"sourceAttributeID", (String)parserContext.getReaderContext().getResource().getDescription(), (String)(InputAttributeDefinitionParser.ELEMENT_NAME.getLocalPart() + " or " + InputDataConnectorParser.ELEMENT_NAME.getLocalPart()));
        }
        if ((attributeEncoders = ElementSupport.getChildElements((Node)config, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "AttributeEncoder"))) != null && !attributeEncoders.isEmpty()) {
            this.log.debug("{} Adding {} encoders", (Object)this.getLogPrefix(), (Object)attributeEncoders.size());
            builder.addPropertyValue("attributeEncoders", (Object)SpringSupport.parseCustomElements((Collection)attributeEncoders, (ParserContext)parserContext));
        }
    }

    protected Map<Locale, String> processLocalizedElement(@Nonnull List<Element> elements) {
        ManagedMap localizedString = new ManagedMap(elements.size());
        for (Element element : elements) {
            localizedString.put(AttributeSupport.getXMLLangAsLocale((Element)element), element.getTextContent());
        }
        return localizedString;
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Attribute Definition '").append(this.getDefinitionId()).append("':");
        return builder.toString();
    }
}

