/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.ad.impl.TemplateAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.AbstractWarningAttributeDefinitionParser;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemplateAttributeDefinitionParser
extends AbstractWarningAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME_AD = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Template");
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "Template");
    @Nonnull
    public static final QName TEMPLATE_ELEMENT_NAME_AD = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Template");
    @Nonnull
    public static final QName TEMPLATE_ELEMENT_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "Template");
    @Nonnull
    public static final QName SOURCE_ATTRIBUTE_ELEMENT_NAME_AD = new QName("urn:mace:shibboleth:2.0:resolver:ad", "SourceAttribute");
    @Nonnull
    public static final QName SOURCE_ATTRIBUTE_ELEMENT_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "SourceAttribute");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplateAttributeDefinitionParser.class);

    protected Class<TemplateAttributeDefinition> getBeanClass(@Nullable Element element) {
        return TemplateAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String velocityEngineRef;
        super.doParse(config, parserContext, builder);
        List templateElements = ElementSupport.getChildElements((Node)config, (QName)TEMPLATE_ELEMENT_NAME_AD);
        templateElements.addAll(ElementSupport.getChildElements((Node)config, (QName)TEMPLATE_ELEMENT_NAME_RESOLVER));
        if (null == templateElements || templateElements.isEmpty()) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)("Missing " + TEMPLATE_ELEMENT_NAME_RESOLVER.getLocalPart()), (String)parserContext.getReaderContext().getResource().getDescription(), (String)"by providing an explicit template");
        } else {
            if (templateElements.size() > 1) {
                this.log.warn("{} Too many <Template> elements, taking the first");
            }
            String templateText = StringSupport.trimOrNull((String)((Element)templateElements.get(0)).getTextContent());
            this.log.debug("{} Template is '{}'", (Object)this.getLogPrefix(), (Object)templateText);
            builder.addPropertyValue("templateText", (Object)templateText);
        }
        List sourceAttributeElements = ElementSupport.getChildElements((Node)config, (QName)SOURCE_ATTRIBUTE_ELEMENT_NAME_AD);
        sourceAttributeElements.addAll(ElementSupport.getChildElements((Node)config, (QName)SOURCE_ATTRIBUTE_ELEMENT_NAME_RESOLVER));
        if (null != sourceAttributeElements && !sourceAttributeElements.isEmpty()) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)SOURCE_ATTRIBUTE_ELEMENT_NAME_RESOLVER.getLocalPart(), (String)parserContext.getReaderContext().getResource().getDescription(), (String)"by using <InputAttributeDefinition> and <InputDataConnector>");
            ManagedList sourceAttributes = new ManagedList(sourceAttributeElements.size());
            for (Element element : sourceAttributeElements) {
                sourceAttributes.add(StringSupport.trimOrNull((String)element.getTextContent()));
            }
            this.log.debug("{} Source attributes are '{}'.", (Object)this.getLogPrefix(), (Object)sourceAttributes);
            builder.addPropertyValue("sourceAttributes", (Object)sourceAttributes);
        }
        if (null == (velocityEngineRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "velocityEngine")))) {
            velocityEngineRef = "shibboleth.VelocityEngine";
        }
        this.log.debug("{} Velocity engine reference '{}'.", (Object)this.getLogPrefix(), (Object)velocityEngineRef);
        builder.addPropertyReference("velocityEngine", velocityEngineRef);
    }

    @Override
    @Nonnull
    protected QName getPreferredName() {
        return TYPE_NAME_RESOLVER;
    }
}

