/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.rdbms.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.DataSourceValidator;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.RDBMSDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.StringResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.TemplatedExecutableStatementBuilder;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.AbstractWarningDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ManagedConnectionParser;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RDBMSDataConnectorParser
extends AbstractWarningDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "RelationalDatabase");
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "RelationalDatabase");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RDBMSDataConnectorParser.class);

    protected Class<RDBMSDataConnector> getNativeBeanClass() {
        return RDBMSDataConnector.class;
    }

    @Override
    @Nonnull
    protected QName getPreferredName() {
        return TYPE_NAME_RESOLVER;
    }

    @Override
    protected void doV2Parse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String mappingStrategyID;
        BeanDefinition dataSource;
        this.log.debug("{} Parsing v2 configuration {}", (Object)this.getLogPrefix(), (Object)config);
        V2Parser v2Parser = new V2Parser(config, this.getLogPrefix());
        String dataSourceID = ManagedConnectionParser.getBeanDataSourceID(config);
        if (dataSourceID != null) {
            dataSource = null;
            builder.addPropertyReference("DataSource", dataSourceID);
        } else {
            dataSource = v2Parser.createManagedDataSource();
            builder.addPropertyValue("DataSource", (Object)v2Parser.createManagedDataSource());
        }
        String searchBuilderID = v2Parser.getBeanSearchBuilderID();
        if (searchBuilderID != null) {
            builder.addPropertyReference("executableSearchBuilder", searchBuilderID);
        } else {
            BeanDefinition def = v2Parser.createTemplateBuilder();
            if (def != null) {
                builder.addPropertyValue("executableSearchBuilder", (Object)def);
            }
        }
        String connectionReadOnly = v2Parser.getConnectionReadOnly();
        if (connectionReadOnly != null) {
            builder.addPropertyValue("connectionReadOnly", (Object)connectionReadOnly);
        }
        if ((mappingStrategyID = v2Parser.getBeanMappingStrategyID()) != null) {
            builder.addPropertyReference("mappingStrategy", mappingStrategyID);
        } else {
            BeanDefinition def = v2Parser.createMappingStrategy();
            if (def != null) {
                builder.addPropertyValue("mappingStrategy", (Object)def);
            }
        }
        String validatorID = v2Parser.getBeanValidatorID();
        if (validatorID != null) {
            builder.addPropertyReference("validator", validatorID);
        } else if (dataSourceID != null) {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator(dataSourceID));
        } else {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator(dataSource));
        }
        String resultCacheBeanID = CacheConfigParser.getBeanResultCacheID(config);
        if (null != resultCacheBeanID) {
            builder.addPropertyReference("resultsCache", resultCacheBeanID);
        } else {
            builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache(parserContext));
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected static class V2Parser {
        private final Element configElement;
        private final Logger log = LoggerFactory.getLogger(V2Parser.class);
        @Nonnull
        @NotEmpty
        private final String logPrefix;

        public V2Parser(@Nonnull Element config, @Nonnull @NotEmpty String prefix) {
            Constraint.isNotNull((Object)config, (String)"RelationalDatabase element cannot be null");
            this.configElement = config;
            this.logPrefix = prefix;
            if (AttributeSupport.hasAttribute((Element)config, (QName)new QName("queryUsesStoredProcedure"))) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"queryUsesStoredProcedure", (String)prefix, null);
            }
            if (AttributeSupport.hasAttribute((Element)config, (QName)new QName("cacheResults"))) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"cacheResults", (String)prefix, (String)"<ResultCache>");
            }
        }

        @Nonnull
        public BeanDefinition createManagedDataSource() {
            ManagedConnectionParser parser = new ManagedConnectionParser(this.configElement);
            return parser.createDataSource();
        }

        @Nullable
        public String getConnectionReadOnly() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("readOnlyConnection"));
        }

        @Nullable
        public String getBeanSearchBuilderID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"executableSearchBuilderRef");
        }

        @Nonnull
        public BeanDefinition createTemplateBuilder() {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedExecutableStatementBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttribute("templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            templateBuilder.addPropertyValue("v2Compatibility", (Object)true);
            String queryTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("queryTimeout"));
            if (queryTimeout != null) {
                BeanDefinitionBuilder duration = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                duration.addConstructorArgValue((Object)queryTimeout);
                duration.addConstructorArgValue((Object)1);
                templateBuilder.addPropertyValue("queryTimeout", (Object)duration.getBeanDefinition());
            }
            List queryTemplates = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "QueryTemplate"));
            queryTemplates.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "QueryTemplate")));
            if (queryTemplates.size() > 1) {
                this.log.warn("{} A maximum of 1 <QueryTemplate> should be specified; the first one has been used", (Object)this.getLogPrefix());
            }
            String queryText = !queryTemplates.isEmpty() ? ((Element)queryTemplates.get(0)).getTextContent() : null;
            templateBuilder.addPropertyValue("templateText", (Object)queryText);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            return templateBuilder.getBeanDefinition();
        }

        @Nullable
        public String getBeanMappingStrategyID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"mappingStrategyRef");
        }

        @Nullable
        public BeanDefinition createMappingStrategy() {
            String multipleResultsIsError;
            String noResultIsError;
            BeanDefinitionBuilder mapper = BeanDefinitionBuilder.genericBeanDefinition(StringResultMappingStrategy.class);
            List columns = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver:dc", (String)"Column");
            columns.addAll(ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"Column"));
            if (!columns.isEmpty()) {
                ManagedMap renamingMap = new ManagedMap();
                for (Element column : columns) {
                    String columnName = AttributeSupport.getAttributeValue((Element)column, null, (String)"columnName");
                    String attributeId = AttributeSupport.getAttributeValue((Element)column, null, (String)"attributeID");
                    if (columnName != null && attributeId != null) {
                        renamingMap.put((Object)columnName, (Object)attributeId);
                    }
                    if (!AttributeSupport.hasAttribute((Element)column, (QName)new QName("type"))) continue;
                    LoggerFactory.getLogger(RDBMSDataConnectorParser.class).warn("{} Column type attribute is no longer supported", (Object)this.getLogPrefix());
                }
                mapper.addPropertyValue("resultRenamingMap", (Object)renamingMap);
            }
            if ((noResultIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("noResultIsError"))) != null) {
                mapper.addPropertyValue("noResultAnError", (Object)noResultIsError);
            }
            if ((multipleResultsIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("multipleResultsIsError"))) != null) {
                mapper.addPropertyValue("multipleResultsAnError", (Object)multipleResultsIsError);
            }
            return mapper.getBeanDefinition();
        }

        @Nullable
        public String getBeanValidatorID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"validatorRef");
        }

        @Nullable
        public BeanDefinition createValidator(Object dataSource) {
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.genericBeanDefinition(DataSourceValidator.class);
            validator.setInitMethodName("initialize");
            validator.setDestroyMethodName("destroy");
            if (dataSource instanceof String) {
                validator.addPropertyReference("dataSource", (String)dataSource);
            } else {
                validator.addPropertyValue("dataSource", dataSource);
            }
            validator.addPropertyValue("throwValidateError", (Object)true);
            return validator.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createCache(@Nonnull ParserContext parserContext) {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache(parserContext);
        }

        @Nonnull
        @NotEmpty
        private String getLogPrefix() {
            return this.logPrefix;
        }

        @Duration
        public static long buildDuration(@Duration long duration, long divisor) {
            return duration / divisor;
        }
    }
}

