/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.enc;

import javax.annotation.Nonnull;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.logic.RelyingPartyIdPredicate;
import net.shibboleth.idp.profile.logic.ScriptedPredicate;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.ScriptTypeBeanParser;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseAttributeEncoderParser
extends AbstractSingleBeanDefinitionParser {
    @Nonnull
    @NotEmpty
    public static final String NAME_ATTRIBUTE_NAME = "name";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseAttributeEncoderParser.class);
    private boolean nameRequired = false;

    public void setNameRequired(boolean flag) {
        this.nameRequired = flag;
    }

    protected void doParse(Element config, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String attributeName = StringSupport.trimOrNull((String)config.getAttributeNS(null, NAME_ATTRIBUTE_NAME));
        if (this.nameRequired && attributeName == null) {
            throw new BeanCreationException("Attribute encoder must contain a name property");
        }
        if (config.hasAttributeNS(null, "activationConditionRef")) {
            if (config.hasAttributeNS(null, "relyingParties")) {
                this.log.warn("relyingParties ignored, using activationConditionRef");
            }
            builder.addPropertyReference("activationCondition", StringSupport.trimOrNull((String)config.getAttributeNS(null, "activationConditionRef")));
        } else if (config.hasAttributeNS(null, "relyingParties")) {
            BeanDefinitionBuilder rpBuilder = BeanDefinitionBuilder.genericBeanDefinition(RelyingPartyIdPredicate.class);
            rpBuilder.setFactoryMethod("fromCandidates");
            rpBuilder.addConstructorArgValue((Object)SpringSupport.getAttributeValueAsList((Attr)config.getAttributeNodeNS(null, "relyingParties")));
            builder.addPropertyValue("activationCondition", (Object)rpBuilder.getBeanDefinition());
        } else {
            Element child = ElementSupport.getFirstChildElement((Node)config);
            if (child != null && ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:resolver", (String)"ActivationConditionScript")) {
                builder.addPropertyValue("activationCondition", (Object)ScriptTypeBeanParser.parseScriptType(ScriptedPredicate.class, (Element)child).getBeanDefinition());
            }
        }
        if (config.hasAttributeNS(null, "encodeType")) {
            builder.addPropertyValue("encodeType", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "encodeType")));
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        builder.addPropertyValue(NAME_ATTRIBUTE_NAME, (Object)attributeName);
    }

    public boolean shouldGenerateId() {
        return true;
    }

    protected boolean shouldParseNameAsAliases() {
        return false;
    }
}

