/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.mapped.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.MappedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.AbstractWarningAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.mapped.impl.ValueMapParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MappedAttributeDefinitionParser
extends AbstractWarningAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME_AD = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Mapped");
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "Mapped");
    @Nonnull
    public static final QName DEFAULT_VALUE_ELEMENT_NAME_AD = new QName("urn:mace:shibboleth:2.0:resolver:ad", "DefaultValue");
    @Nonnull
    public static final QName DEFAULT_VALUE_ELEMENT_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "DefaultValue");
    @Nonnull
    private Logger log = LoggerFactory.getLogger(MappedAttributeDefinitionParser.class);

    protected Class<MappedAttributeDefinition> getBeanClass(@Nullable Element element) {
        return MappedAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        List defaultValueElements = ElementSupport.getChildElements((Node)config, (QName)DEFAULT_VALUE_ELEMENT_NAME_AD);
        defaultValueElements.addAll(ElementSupport.getChildElements((Node)config, (QName)DEFAULT_VALUE_ELEMENT_NAME_RESOLVER));
        String defaultValue = null;
        String passThru = null;
        if (null != defaultValueElements && defaultValueElements.size() > 0) {
            if (defaultValueElements.size() > 1) {
                this.log.warn("{} More than one <DefaultValue> specified, taking the first");
            }
            Element defaultValueElement = (Element)defaultValueElements.get(0);
            defaultValue = StringSupport.trimOrNull((String)defaultValueElement.getTextContent());
            if (defaultValueElement.hasAttributeNS(null, "passThru")) {
                if (null != defaultValue) {
                    this.log.info("{} Default value and passThru both specified", (Object)this.getLogPrefix(), (Object)this.getDefinitionId());
                }
                passThru = StringSupport.trimOrNull((String)defaultValueElement.getAttributeNS(null, "passThru"));
                builder.addPropertyValue("passThru", (Object)passThru);
            }
        }
        List valueMapElements = ElementSupport.getChildElements((Node)config, (QName)ValueMapParser.TYPE_NAME_AD);
        valueMapElements.addAll(ElementSupport.getChildElements((Node)config, (QName)ValueMapParser.TYPE_NAME_RESOLVER));
        if (null == valueMapElements || valueMapElements.size() == 0) {
            throw new BeanCreationException("Attribute Definition '" + this.getDefinitionId() + "' At least one ValueMap must be specified");
        }
        ManagedList valueMaps = SpringSupport.parseCustomElements((Collection)valueMapElements, (ParserContext)parserContext);
        this.log.debug("{} passThru = {}, defaultValue = {}, {} value maps", new Object[]{this.getLogPrefix(), passThru, defaultValue, valueMaps.size()});
        this.log.trace("{} Value maps {}", (Object)this.getLogPrefix(), (Object)valueMaps);
        builder.addPropertyValue("defaultValue", (Object)defaultValue);
        builder.addPropertyValue("valueMaps", (Object)valueMaps);
    }

    @Override
    @Nonnull
    protected QName getPreferredName() {
        return TYPE_NAME_RESOLVER;
    }
}

