/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ManagedConnectionParser;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CacheConfigParser {
    @Nonnull
    public static final QName RESULT_CACHE_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "ResultCache");
    @Nonnull
    public static final QName RESULT_CACHE_BEAN_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "ResultCacheBean");
    @Nonnull
    public static final QName RESULT_CACHE_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ResultCache");
    @Nonnull
    public static final QName RESULT_CACHE_BEAN_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ResultCacheBean");
    private static final long DEFAULT_CACHE_ENTRIES = 500L;
    private static final long DEFAULT_TTL_MS = 14400000L;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CacheConfigParser.class);
    @Nonnull
    private final Element configElement;

    public CacheConfigParser(@Nonnull Element config) {
        Constraint.isNotNull((Object)config, (String)"Element cannot be null");
        this.configElement = config;
    }

    @Nonnull
    public BeanDefinition createCache(@Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder cache;
        Element cacheElement;
        String elementTimeToLive;
        String defaultCache = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("cacheResults"));
        if (defaultCache != null) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"cacheResults", (String)(parserContext != null ? parserContext.getReaderContext().getResource().getDescription() : null), (String)RESULT_CACHE_RESOLVER.toString());
            return null;
        }
        List cacheElements = ElementSupport.getChildElements((Node)this.configElement, (QName)RESULT_CACHE_DC);
        cacheElements.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)RESULT_CACHE_RESOLVER));
        if (cacheElements.isEmpty()) {
            return null;
        }
        if (cacheElements.size() > 1) {
            this.log.warn("Only one <ResultCache> element can be specified, the first one has been taken");
        }
        if (null != (elementTimeToLive = AttributeSupport.getAttributeValue((Element)(cacheElement = (Element)cacheElements.get(0)), (QName)new QName("elementTimeToLive")))) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"elementTimeToLive", parserContext != null ? parserContext.getReaderContext().getResource().getDescription() : null, (String)"expireAfterAccess");
        }
        String expireAfterWrite = AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("expireAfterWrite"));
        String expireAfterAccess = AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("expireAfterAccess"));
        if (expireAfterWrite != null) {
            if (null != expireAfterAccess || null != elementTimeToLive) {
                this.log.warn("ResultCache: Attribute 'expireAfterAccess' is mutually exclusive with 'expireAfterWrite'. Used 'expireAfterWrite'.");
            }
            cache = BeanDefinitionBuilder.rootBeanDefinition(CacheConfigParser.class, (String)"buildCacheWrite");
            cache.addConstructorArgValue((Object)expireAfterWrite);
        } else if (elementTimeToLive != null) {
            cache = BeanDefinitionBuilder.rootBeanDefinition(CacheConfigParser.class, (String)"buildCacheAccess");
            cache.addConstructorArgValue((Object)elementTimeToLive);
        } else {
            cache = BeanDefinitionBuilder.rootBeanDefinition(CacheConfigParser.class, (String)"buildCacheAccess");
            cache.addConstructorArgValue((Object)expireAfterAccess);
        }
        cache.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("maximumCachedElements")));
        return cache.getBeanDefinition();
    }

    private static long getMaxSize(@Nullable String maximumSize) {
        if (maximumSize != null) {
            return Long.parseLong(maximumSize);
        }
        return 500L;
    }

    private static long getTimeToLiveMs(@Nullable String timeToLive) {
        if (timeToLive != null) {
            return DOMTypeSupport.durationToLong((String)timeToLive);
        }
        return 14400000L;
    }

    @Nullable
    public static Cache<String, Map<String, IdPAttribute>> buildCacheAccess(@Nullable String timeToLive, @Nullable String maximumSize) {
        return CacheBuilder.newBuilder().maximumSize(CacheConfigParser.getMaxSize(maximumSize)).expireAfterAccess(CacheConfigParser.getTimeToLiveMs(timeToLive), TimeUnit.MILLISECONDS).build();
    }

    @Nullable
    public static Cache<String, Map<String, IdPAttribute>> buildCacheWrite(@Nullable String timeToLive, @Nullable String maximumSize) {
        return CacheBuilder.newBuilder().maximumSize(CacheConfigParser.getMaxSize(maximumSize)).expireAfterWrite(CacheConfigParser.getTimeToLiveMs(timeToLive), TimeUnit.MILLISECONDS).build();
    }

    @Nullable
    public static String getBeanResultCacheID(@Nonnull Element config) {
        List beanResultCache = ElementSupport.getChildElements((Node)config, (QName)RESULT_CACHE_BEAN_DC);
        beanResultCache.addAll(ElementSupport.getChildElements((Node)config, (QName)RESULT_CACHE_BEAN_RESOLVER));
        if (beanResultCache.isEmpty()) {
            return null;
        }
        if (beanResultCache.size() > 1) {
            LoggerFactory.getLogger(ManagedConnectionParser.class).warn("Only one <ResultCacheBean> should be specified; the first one has been consulted");
        }
        List resultCacheElements = ElementSupport.getChildElements((Node)config, (QName)RESULT_CACHE_DC);
        resultCacheElements.addAll(ElementSupport.getChildElements((Node)config, (QName)RESULT_CACHE_RESOLVER));
        if (resultCacheElements.size() > 0) {
            LoggerFactory.getLogger(ManagedConnectionParser.class).warn("<ResultCacheBean> is incompatible with <ResultCache>. The <ResultCacheBean> has been used");
        }
        return StringSupport.trimOrNull((String)ElementSupport.getElementContentAsString((Element)((Element)beanResultCache.get(0))));
    }
}

