/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.enc.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.AbstractWarningAttributeEncoderParser;
import net.shibboleth.idp.saml.attribute.encoding.impl.SAML2StringAttributeEncoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SAML2StringAttributeEncoderParser
extends AbstractWarningAttributeEncoderParser {
    @Nonnull
    public static final QName TYPE_NAME_ENC = new QName("urn:mace:shibboleth:2.0:attribute:encoder", "SAML2String");
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "SAML2String");
    @Nonnull
    @NotEmpty
    public static final String NAME_FORMAT_ATTRIBUTE_NAME = "nameFormat";
    @Nonnull
    @NotEmpty
    public static final String FRIENDLY_NAME_ATTRIBUTE_NAME = "friendlyName";

    public SAML2StringAttributeEncoderParser() {
        this.setNameRequired(true);
    }

    protected Class<SAML2StringAttributeEncoder> getBeanClass(@Nullable Element element) {
        return SAML2StringAttributeEncoder.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        if (config.hasAttributeNS(null, NAME_FORMAT_ATTRIBUTE_NAME)) {
            String nameFormat = StringSupport.trimOrNull((String)config.getAttributeNS(null, NAME_FORMAT_ATTRIBUTE_NAME));
            builder.addPropertyValue(NAME_FORMAT_ATTRIBUTE_NAME, (Object)nameFormat);
        }
        builder.addPropertyValue(FRIENDLY_NAME_ATTRIBUTE_NAME, (Object)config.getAttribute(FRIENDLY_NAME_ATTRIBUTE_NAME));
    }

    @Override
    @Nonnull
    protected QName getPreferredName() {
        return TYPE_NAME_RESOLVER;
    }
}

