/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.pc.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.pc.impl.AbstractPrincipalConnectorParser;
import net.shibboleth.idp.saml.nameid.impl.TransientNameIDDecoder;
import net.shibboleth.idp.saml.nameid.impl.TransientNameIdentifierDecoder;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class TransientConnectorParser
extends AbstractPrincipalConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:pc", "Transient");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TransientConnectorParser.class);

    @Override
    protected void addSAMLDecoders(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String idStore = "shibboleth.StorageService";
        if (config.hasAttributeNS(null, "storageServiceRef")) {
            idStore = StringSupport.trimOrNull((String)config.getAttributeNS(null, "storageServiceRef"));
        }
        BeanDefinitionBuilder subBuilder = BeanDefinitionBuilder.genericBeanDefinition(TransientNameIDDecoder.class);
        subBuilder.setInitMethodName("initialize");
        subBuilder.setDestroyMethodName("destroy");
        subBuilder.addPropertyReference("idStore", idStore);
        String id = StringSupport.trimOrNull((String)config.getAttributeNS(null, "id"));
        subBuilder.addPropertyValue("id", (Object)id);
        builder.addPropertyValue("nameIDDecoder", (Object)subBuilder.getBeanDefinition());
        if (config.hasAttributeNS(null, "noResultIsError")) {
            this.log.warn("Transient PrincipalConnector does not support 'noResultIsError' attribute");
        }
        subBuilder = BeanDefinitionBuilder.genericBeanDefinition(TransientNameIdentifierDecoder.class);
        subBuilder.setInitMethodName("initialize");
        subBuilder.setDestroyMethodName("destroy");
        subBuilder.addPropertyReference("idStore", idStore);
        subBuilder.addPropertyValue("id", (Object)id);
        builder.addPropertyValue("nameIdentifierDecoder", (Object)subBuilder.getBeanDefinition());
    }
}

