/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.impl.InputAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.impl.InputDataConnectorParser;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseComputedIDDataConnectorParser
extends BaseResolverPluginParser {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseComputedIDDataConnectorParser.class);

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder, @Nullable String generatedIdDefaultName) {
        String salt;
        super.doParse(config, parserContext, builder);
        QName suppliedQname = DOMTypeSupport.getXSIType((Element)config);
        if (!"urn:mace:shibboleth:2.0:resolver".equals(suppliedQname.getNamespaceURI())) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.XSITYPE, (String)suppliedQname.toString(), (String)parserContext.getReaderContext().getResource().getDescription(), (String)this.getPreferredName().toString());
        }
        String generatedAttribute = config.hasAttributeNS(null, "generatedAttributeID") ? StringSupport.trimOrNull((String)config.getAttributeNS(null, "generatedAttributeID")) : generatedIdDefaultName;
        List failoverConnector = ElementSupport.getChildElements((Node)config, (QName)AbstractDataConnectorParser.FAILOVER_DATA_CONNECTOR_ELEMENT_NAME);
        if (failoverConnector != null && !failoverConnector.isEmpty()) {
            if (failoverConnector.size() > 1) {
                this.log.warn("{} More than one failover data connector specified, taking the first", (Object)this.getLogPrefix());
            }
            String connectorId = StringSupport.trimOrNull((String)((Element)failoverConnector.get(0)).getAttributeNS(null, "ref"));
            this.log.debug("{} Setting the following failover data connector dependencies: {}", (Object)this.getLogPrefix(), (Object)connectorId);
            builder.addPropertyValue("failoverDataConnectorId", (Object)connectorId);
        }
        if (config.hasAttributeNS(null, "algorithm")) {
            builder.addPropertyValue("algorithm", (Object)config.getAttributeNS(null, "algorithm"));
        }
        if (config.hasAttributeNS(null, "encoding")) {
            builder.addPropertyValue("encoding", (Object)config.getAttributeNS(null, "encoding"));
        }
        if (config.hasAttributeNS(null, "sourceAttributeID")) {
            String sourceAttribute = StringSupport.trimOrNull((String)config.getAttributeNS(null, "sourceAttributeID"));
            builder.addPropertyValue("sourceAttributeId", (Object)sourceAttribute);
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"sourceAttributeID", (String)parserContext.getReaderContext().getResource().getDescription(), (String)(InputAttributeDefinitionParser.ELEMENT_NAME.getLocalPart() + " or " + InputDataConnectorParser.ELEMENT_NAME.getLocalPart()));
        }
        if (null == (salt = AttributeSupport.hasAttribute((Element)config, (QName)new QName("salt")) ? config.getAttributeNS(null, "salt") : null)) {
            this.log.debug("{} Generated Attribute: '{}', no salt provided", (Object)this.getLogPrefix(), (Object)generatedAttribute);
        } else {
            this.log.debug("{} Generated Attribute: '{}', see TRACE log for the salt value", (Object)this.getLogPrefix(), (Object)generatedAttribute);
            this.log.trace("{} salt: '{}'", (Object)this.getLogPrefix(), (Object)salt);
        }
        builder.addPropertyValue("generatedAttributeId", (Object)generatedAttribute);
        builder.addPropertyValue("salt", (Object)salt);
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Data Connector '").append(this.getDefinitionId()).append("':");
        return builder.toString();
    }

    protected abstract QName getPreferredName();
}

