/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagedConnectionParser {
    @Nonnull
    public static final QName CONTAINER_MANAGED_CONNECTION_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "ContainerManagedConnection");
    @Nonnull
    public static final QName CONTAINER_MANAGED_CONNECTION_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ContainerManagedConnection");
    @Nonnull
    public static final QName APPLICATION_MANAGED_CONNECTION_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "ApplicationManagedConnection");
    @Nonnull
    public static final QName APPLICATION_MANAGED_CONNECTION_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ApplicationManagedConnection");
    @Nonnull
    public static final QName BEAN_MANAGED_CONNECTION_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "BeanManagedConnection");
    @Nonnull
    public static final QName BEAN_MANAGED_CONNECTION_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "BeanManagedConnection");
    @Nonnull
    public static final QName SIMPLE_MANAGED_CONNECTION_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "SimpleManagedConnection");
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(ManagedConnectionParser.class);
    @Nonnull
    private final Element configElement;

    public ManagedConnectionParser(@Nonnull Element config) {
        Constraint.isNotNull((Object)config, (String)"Element cannot be null");
        this.configElement = config;
    }

    @Nullable
    public BeanDefinition createDataSource() {
        List containerManagedElements = ElementSupport.getChildElements((Node)this.configElement, (QName)CONTAINER_MANAGED_CONNECTION_DC);
        containerManagedElements.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)CONTAINER_MANAGED_CONNECTION_RESOLVER));
        List applicationManagedElements = ElementSupport.getChildElements((Node)this.configElement, (QName)APPLICATION_MANAGED_CONNECTION_DC);
        applicationManagedElements.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)APPLICATION_MANAGED_CONNECTION_RESOLVER));
        List simpleManagedElements = ElementSupport.getChildElements((Node)this.configElement, (QName)SIMPLE_MANAGED_CONNECTION_RESOLVER);
        if (simpleManagedElements.size() + containerManagedElements.size() + applicationManagedElements.size() > 1) {
            LOG.warn("Only one <ApplicationManagedConnection>, <SimpleManagedConnection> or <ContainerManagedConnection> is allowed per DataConnector");
        }
        if (!simpleManagedElements.isEmpty()) {
            return this.createSimpleManagedDataSource((Element)simpleManagedElements.get(0));
        }
        if (!containerManagedElements.isEmpty()) {
            return this.createContainerManagedDataSource((Element)containerManagedElements.get(0));
        }
        if (!applicationManagedElements.isEmpty()) {
            return this.createApplicationManagedDataSource((Element)applicationManagedElements.get(0));
        }
        return null;
    }

    @Nonnull
    protected BeanDefinition createContainerManagedDataSource(@Nonnull Element containerManagedElement) {
        Constraint.isNotNull((Object)containerManagedElement, (String)"ContainerManagedConnection element cannot be null");
        String resourceName = AttributeSupport.getAttributeValue((Element)containerManagedElement, (QName)new QName("resourceName"));
        ManagedMap props = new ManagedMap();
        List elements = ElementSupport.getChildElementsByTagNameNS((Node)containerManagedElement, (String)"urn:mace:shibboleth:2.0:resolver:dc", (String)"JNDIConnectionProperty");
        elements.addAll(ElementSupport.getChildElementsByTagNameNS((Node)containerManagedElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"JNDIConnectionProperty"));
        if (!elements.isEmpty()) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)"<JNDIConnectionProperty>", null, null);
            for (Element e : elements) {
                props.put((Object)AttributeSupport.getAttributeValue((Element)e, (QName)new QName("name")), (Object)AttributeSupport.getAttributeValue((Element)e, (QName)new QName("value")));
            }
        }
        BeanDefinitionBuilder dataSource = BeanDefinitionBuilder.rootBeanDefinition(ManagedConnectionParser.class, (String)"buildDataSource");
        dataSource.addConstructorArgValue((Object)props);
        dataSource.addConstructorArgValue((Object)resourceName);
        return dataSource.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition createSimpleManagedDataSource(@Nonnull Element simpleManagedElement) {
        String password;
        Constraint.isNotNull((Object)simpleManagedElement, (String)"SimpleManagedConnection element cannot be null");
        BeanDefinitionBuilder dataSource = BeanDefinitionBuilder.genericBeanDefinition(BasicDataSource.class);
        String driverName = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)simpleManagedElement, null, (String)"jdbcDriver"));
        if (driverName == null) {
            LOG.warn("<SimpleManagedConnection> jdbcDriver attribute should be present and non empty");
            throw new BeanCreationException("<SimpleManagedConnection> jdbcDriver attribute should be present and non empty");
        }
        dataSource.addPropertyValue("driverClassName", (Object)driverName);
        String url = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)simpleManagedElement, null, (String)"jdbcURL"));
        if (url == null) {
            LOG.warn("<SimpleManagedConnection> jdbcURL attribute should be present and non empty");
            throw new BeanCreationException("<SimpleManagedConnection> jdbcURL attribute should be present and non empty");
        }
        dataSource.addPropertyValue("url", (Object)url);
        String user = AttributeSupport.getAttributeValue((Element)simpleManagedElement, null, (String)"jdbcUserName");
        if (user != null && !"".equals(user)) {
            dataSource.addPropertyValue("username", (Object)user);
        }
        if ((password = AttributeSupport.getAttributeValue((Element)simpleManagedElement, null, (String)"jdbcPassword")) != null && !"".equals(password)) {
            dataSource.addPropertyValue("password", (Object)password);
        }
        dataSource.addPropertyValue("maxTotal", (Object)"20");
        dataSource.addPropertyValue("maxIdle", (Object)"5");
        dataSource.addPropertyValue("maxWaitMillis", (Object)"5000");
        return dataSource.getBeanDefinition();
    }

    @Deprecated
    @Nonnull
    protected BeanDefinition createApplicationManagedDataSource(@Nonnull Element applicationManagedElement) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)APPLICATION_MANAGED_CONNECTION_RESOLVER.getLocalPart(), null, (String)(BEAN_MANAGED_CONNECTION_RESOLVER.getLocalPart() + " or " + SIMPLE_MANAGED_CONNECTION_RESOLVER.getLocalPart()));
        Constraint.isNotNull((Object)applicationManagedElement, (String)"ApplicationManagedConnection element cannot be null");
        BeanDefinitionBuilder dataSource = BeanDefinitionBuilder.genericBeanDefinition(ComboPooledDataSource.class);
        BeanDefinitionBuilder jdbcDriver = BeanDefinitionBuilder.rootBeanDefinition(ManagedConnectionParser.class, (String)"loadJdbcDriver");
        jdbcDriver.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("jdbcDriver")));
        dataSource.addPropertyValue("driverClass", (Object)jdbcDriver.getBeanDefinition());
        dataSource.addPropertyValue("jdbcUrl", (Object)AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("jdbcURL")));
        dataSource.addPropertyValue("user", (Object)AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("jdbcUserName")));
        dataSource.addPropertyValue("password", (Object)AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("jdbcPassword")));
        String poolAcquireIncrement = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolAcquireIncrement"));
        if (poolAcquireIncrement != null) {
            dataSource.addPropertyValue("acquireIncrement", (Object)poolAcquireIncrement);
        } else {
            dataSource.addPropertyValue("acquireIncrement", (Object)3);
        }
        String poolAcquireRetryAttempts = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolAcquireRetryAttempts"));
        if (poolAcquireRetryAttempts != null) {
            dataSource.addPropertyValue("acquireRetryAttempts", (Object)poolAcquireRetryAttempts);
        } else {
            dataSource.addPropertyValue("acquireRetryAttempts", (Object)36);
        }
        String poolAcquireRetryDelay = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolAcquireRetryDelay"));
        if (poolAcquireRetryDelay != null) {
            dataSource.addPropertyValue("acquireRetryDelay", (Object)poolAcquireRetryDelay);
        } else {
            dataSource.addPropertyValue("acquireRetryDelay", (Object)5000);
        }
        String poolBreakAfterAcquireFailure = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolBreakAfterAcquireFailure"));
        if (poolBreakAfterAcquireFailure != null) {
            dataSource.addPropertyValue("breakAfterAcquireFailure", (Object)poolBreakAfterAcquireFailure);
        } else {
            dataSource.addPropertyValue("breakAfterAcquireFailure", (Object)true);
        }
        String poolMinSize = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolMinSize"));
        if (poolMinSize != null) {
            dataSource.addPropertyValue("minPoolSize", (Object)poolMinSize);
        } else {
            dataSource.addPropertyValue("minPoolSize", (Object)2);
        }
        String poolMaxSize = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolMaxSize"));
        if (poolMaxSize != null) {
            dataSource.addPropertyValue("maxPoolSize", (Object)poolMaxSize);
        } else {
            dataSource.addPropertyValue("maxPoolSize", (Object)50);
        }
        String poolMaxIdleTime = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolMaxIdleTime"));
        if (poolMaxIdleTime != null) {
            dataSource.addPropertyValue("maxIdleTime", (Object)poolMaxIdleTime);
        } else {
            dataSource.addPropertyValue("maxIdleTime", (Object)600);
        }
        String poolIdleTestPeriod = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolIdleTestPeriod"));
        if (poolIdleTestPeriod != null) {
            dataSource.addPropertyValue("idleConnectionTestPeriod", (Object)poolIdleTestPeriod);
        } else {
            dataSource.addPropertyValue("idleConnectionTestPeriod", (Object)180);
        }
        return dataSource.getBeanDefinition();
    }

    @Nullable
    public static DataSource buildDataSource(Map<String, String> props, String resourceName) {
        try {
            InitialContext initCtx = new InitialContext(new Hashtable<String, String>(props));
            DataSource dataSource = (DataSource)initCtx.lookup(resourceName);
            return dataSource;
        }
        catch (NamingException e) {
            LOG.error("Managed data source '{}' could not be found", (Object)resourceName, (Object)e);
            return null;
        }
    }

    @Deprecated
    public static String loadJdbcDriver(String jdbcDriver) {
        ClassLoader classLoader = ManagedConnectionParser.class.getClassLoader();
        try {
            classLoader.loadClass(jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            LOG.error("JDBC driver '{}' could not be found", (Object)jdbcDriver, (Object)e);
        }
        return jdbcDriver;
    }

    @Nullable
    public static String getBeanDataSourceID(@Nonnull Element config) {
        List beanManagedElements = ElementSupport.getChildElements((Node)config, (QName)BEAN_MANAGED_CONNECTION_DC);
        beanManagedElements.addAll(ElementSupport.getChildElements((Node)config, (QName)BEAN_MANAGED_CONNECTION_RESOLVER));
        if (beanManagedElements.isEmpty()) {
            return null;
        }
        if (beanManagedElements.size() > 1) {
            LOG.warn("Only one <BeanManagedConnection> should be specified; the first one has been consulted");
        }
        List managedElements = ElementSupport.getChildElements((Node)config, (QName)CONTAINER_MANAGED_CONNECTION_DC);
        managedElements.addAll(ElementSupport.getChildElements((Node)config, (QName)CONTAINER_MANAGED_CONNECTION_RESOLVER));
        managedElements.addAll(ElementSupport.getChildElements((Node)config, (QName)APPLICATION_MANAGED_CONNECTION_DC));
        managedElements.addAll(ElementSupport.getChildElements((Node)config, (QName)APPLICATION_MANAGED_CONNECTION_RESOLVER));
        managedElements.addAll(ElementSupport.getChildElements((Node)config, (QName)SIMPLE_MANAGED_CONNECTION_RESOLVER));
        if (managedElements.size() > 0) {
            LOG.warn("<BeanManagedConnection> is incompatible with <ContainerManagedConnection>, <SimpleManagedConnection> or <ApplicationManagedConnection>. The <BeanManagedConnection> has been used");
        }
        return StringSupport.trimOrNull((String)ElementSupport.getElementContentAsString((Element)((Element)beanManagedElements.get(0))));
    }
}

