/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.dc.impl.StaticDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.AbstractWarningDataConnectorParser;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StaticDataConnectorParser
extends AbstractWarningDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "Static");
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "Static");
    @Nonnull
    public static final QName ATTRIBUTE_ELEMENT_NAME_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "Attribute");
    @Nonnull
    public static final QName ATTRIBUTE_ELEMENT_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "Attribute");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StaticDataConnectorParser.class);

    protected Class<StaticDataConnector> getNativeBeanClass() {
        return StaticDataConnector.class;
    }

    @Override
    protected void doV2Parse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        if (!ElementSupport.getChildElements((Node)config, (QName)FAILOVER_DATA_CONNECTOR_ELEMENT_NAME).isEmpty()) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)FAILOVER_DATA_CONNECTOR_ELEMENT_NAME.getLocalPart(), (String)TYPE_NAME_RESOLVER.toString(), null);
        }
        List children = ElementSupport.getChildElements((Node)config, (QName)ATTRIBUTE_ELEMENT_NAME_DC);
        children.addAll(ElementSupport.getChildElements((Node)config, (QName)ATTRIBUTE_ELEMENT_NAME_RESOLVER));
        ManagedList attributes = new ManagedList(children.size());
        for (Element child : children) {
            String attrId = StringSupport.trimOrNull((String)child.getAttributeNS(null, "id"));
            BeanDefinitionBuilder attributeDefn = BeanDefinitionBuilder.genericBeanDefinition(IdPAttribute.class);
            attributeDefn.addConstructorArgValue((Object)attrId);
            List values = ElementSupport.getChildElementsByTagNameNS((Node)child, (String)"urn:mace:shibboleth:2.0:resolver:dc", (String)"Value");
            values.addAll(ElementSupport.getChildElementsByTagNameNS((Node)child, (String)"urn:mace:shibboleth:2.0:resolver", (String)"Value"));
            ManagedList inValues = new ManagedList(values.size());
            for (Element val : values) {
                BeanDefinitionBuilder value = BeanDefinitionBuilder.genericBeanDefinition(StringAttributeValue.class);
                value.addConstructorArgValue((Object)val.getTextContent());
                this.log.trace("{} Attribute: {}, adding value {}", new Object[]{this.getLogPrefix(), attrId, val.getTextContent()});
                inValues.add((Object)value.getBeanDefinition());
            }
            attributeDefn.addPropertyValue("values", (Object)inValues);
            this.log.debug("{} Adding Attribute: {} with {} values", new Object[]{this.getLogPrefix(), attrId, values.size()});
            attributes.add(attributeDefn.getBeanDefinition());
        }
        builder.addPropertyValue("values", (Object)attributes);
    }

    @Override
    protected boolean warnOnDependencies() {
        return true;
    }

    @Override
    @Nonnull
    protected QName getPreferredName() {
        return TYPE_NAME_RESOLVER;
    }
}

