/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import javax.annotation.Nonnull;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.BaseComputedIDDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ManagedConnectionParser;
import net.shibboleth.idp.saml.attribute.resolver.impl.StoredIDDataConnector;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class StoredIDDataConnectorParser
extends BaseComputedIDDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME_AD = new QName("urn:mace:shibboleth:2.0:resolver:dc", "StoredId");
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "StoredId");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredIDDataConnectorParser.class);

    protected Class<StoredIDDataConnector> getBeanClass(Element element) {
        return StoredIDDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder, "storedId");
        this.log.debug("{} doParse {}", (Object)this.getLogPrefix(), (Object)config);
        String springResources = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("springResources"));
        String beanDataSource = ManagedConnectionParser.getBeanDataSourceID(config);
        if (springResources != null) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"springResources in StoredIDDataConnector", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"<BeanManagedConnection> element");
            builder.addPropertyValue("dataSource", (Object)this.getDataSource(springResources.split(";")));
        } else if (beanDataSource != null) {
            builder.addPropertyReference("dataSource", beanDataSource);
        } else {
            builder.addPropertyValue("dataSource", (Object)this.getv2DataSource(config));
        }
        if (config.hasAttributeNS(null, "queryTimeout")) {
            builder.addPropertyValue("queryTimeout", (Object)config.getAttributeNS(null, "queryTimeout"));
        }
        if (config.hasAttributeNS(null, "transactionRetries")) {
            builder.addPropertyValue("transactionRetries", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "transactionRetries")));
        }
        if (config.hasAttributeNS(null, "failFast")) {
            builder.addPropertyValue("failFast", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "failFast")));
        }
        if (config.hasAttributeNS(null, "retryableErrors")) {
            builder.addPropertyValue("retryableErrors", (Object)SpringSupport.getAttributeValueAsManagedList((Attr)config.getAttributeNodeNS(null, "retryableErrors")));
        }
    }

    @Nonnull
    protected BeanFactory createBeanFactory(String ... springResources) {
        FilesystemGenericApplicationContext ctx = new FilesystemGenericApplicationContext();
        XmlBeanDefinitionReader definitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        definitionReader.setValidationMode(3);
        definitionReader.setNamespaceAware(true);
        definitionReader.loadBeanDefinitions(springResources);
        ctx.refresh();
        return ctx.getBeanFactory();
    }

    protected DataSource getDataSource(String ... springResource) {
        BeanFactory beanFactory = this.createBeanFactory(springResource);
        return (DataSource)beanFactory.getBean(DataSource.class);
    }

    protected BeanDefinition getv2DataSource(@Nonnull Element config) {
        this.log.debug("{} Parsing v2 configuration", (Object)this.getLogPrefix());
        ManagedConnectionParser parser = new ManagedConnectionParser(config);
        return parser.createDataSource();
    }

    @Override
    @Nonnull
    protected QName getPreferredName() {
        return TYPE_NAME_RESOLVER;
    }
}

