/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.ldap.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ConnectionFactoryValidator;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.LDAPDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.StringAttributeValueMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.TemplatedExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.AbstractWarningDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.ldap.impl.CredentialConfigFactoryBean;
import net.shibboleth.idp.profile.spring.factory.BasicX509CredentialFactoryBean;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.handler.CaseChangeEntryHandler;
import org.ldaptive.handler.DnAttributeEntryHandler;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.SearchValidator;
import org.ldaptive.pool.SoftLimitConnectionPool;
import org.ldaptive.provider.ConnectionStrategy;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.ssl.SslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LDAPDataConnectorParser
extends AbstractWarningDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME_DC = new QName("urn:mace:shibboleth:2.0:resolver:dc", "LDAPDirectory");
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "LDAPDirectory");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPDataConnectorParser.class);

    protected Class<LDAPDataConnector> getNativeBeanClass() {
        return LDAPDataConnector.class;
    }

    @Override
    @Nonnull
    protected QName getPreferredName() {
        return TYPE_NAME_RESOLVER;
    }

    @Override
    protected void doV2Parse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        this.log.debug("{} Parsing v2 configuration {}", (Object)this.getLogPrefix(), (Object)config);
        V2Parser v2Parser = new V2Parser(config, this.getLogPrefix());
        BeanDefinitionBuilder connectionFactory = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.class);
        connectionFactory.addConstructorArgValue((Object)v2Parser.createConnectionConfig(parserContext));
        BeanDefinitionBuilder provider = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.getDefaultProvider().getClass());
        BeanDefinitionBuilder providerConfig = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.getDefaultProvider().getProviderConfig().getClass());
        String connectionStrategy = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("connectionStrategy"));
        if (connectionStrategy == null) {
            providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.ACTIVE_PASSIVE);
        } else {
            switch (connectionStrategy) {
                case "DEFAULT": {
                    providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.DEFAULT);
                    break;
                }
                case "ROUND_ROBIN": {
                    providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.ROUND_ROBIN);
                    break;
                }
                case "RANDOM": {
                    providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.RANDOM);
                    break;
                }
                default: {
                    providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.ACTIVE_PASSIVE);
                }
            }
        }
        ManagedMap props = new ManagedMap();
        List propertyElements = ElementSupport.getChildElements((Node)config, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "LDAPProperty"));
        propertyElements.addAll(ElementSupport.getChildElements((Node)config, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "LDAPProperty")));
        for (Element e : propertyElements) {
            String value = AttributeSupport.getAttributeValue((Element)e, (QName)new QName("value"));
            String name = AttributeSupport.getAttributeValue((Element)e, (QName)new QName("name"));
            if ("java.naming.ldap.attributes.binary".equalsIgnoreCase(name)) {
                DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"<LDAPPrpperty name=\"java.naming.ldap.attributes.binary\" ..>", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"<BinaryAttributes> element");
            }
            props.put((Object)name, (Object)value);
        }
        providerConfig.addPropertyValue("properties", (Object)props);
        provider.addPropertyValue("providerConfig", (Object)providerConfig.getBeanDefinition());
        connectionFactory.addPropertyValue("provider", (Object)provider.getBeanDefinition());
        String searchBuilderID = v2Parser.getBeanSearchBuilderID();
        if (searchBuilderID != null) {
            builder.addPropertyReference("executableSearchBuilder", searchBuilderID);
        } else {
            BeanDefinition def = v2Parser.createTemplateBuilder();
            if (def != null) {
                builder.addPropertyValue("executableSearchBuilder", (Object)def);
            }
        }
        BeanDefinition connectionPool = v2Parser.createConnectionPool((BeanDefinition)connectionFactory.getBeanDefinition());
        BeanDefinitionBuilder pooledConnectionFactory = null;
        if (connectionPool != null) {
            pooledConnectionFactory = BeanDefinitionBuilder.genericBeanDefinition(PooledConnectionFactory.class);
            pooledConnectionFactory.addConstructorArgValue((Object)connectionPool);
            builder.addPropertyValue("connectionFactory", (Object)pooledConnectionFactory.getBeanDefinition());
        } else {
            builder.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
        }
        BeanDefinition searchExecutor = v2Parser.createSearchExecutor((ManagedMap<String, String>)props);
        builder.addPropertyValue("searchExecutor", (Object)searchExecutor);
        String mappingStrategyID = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("mappingStrategyRef"));
        if (mappingStrategyID != null) {
            builder.addPropertyReference("mappingStrategy", mappingStrategyID);
        } else {
            BeanDefinition def = v2Parser.createMappingStrategy();
            if (def != null) {
                builder.addPropertyValue("mappingStrategy", (Object)def);
            }
        }
        String validatorID = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("validatorRef"));
        if (validatorID != null) {
            builder.addPropertyReference("validator", validatorID);
        } else if (pooledConnectionFactory != null) {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator((BeanDefinition)pooledConnectionFactory.getBeanDefinition()));
        } else {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator((BeanDefinition)connectionFactory.getBeanDefinition()));
        }
        String resultCacheBeanID = CacheConfigParser.getBeanResultCacheID(config);
        if (null != resultCacheBeanID) {
            builder.addPropertyReference("resultsCache", resultCacheBeanID);
        } else {
            builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache(parserContext));
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected static class V2Parser {
        private final Element configElement;
        private final Logger log = LoggerFactory.getLogger(V2Parser.class);
        private final String logPrefix;

        public V2Parser(@Nonnull Element config, @Nonnull String prefix) {
            Constraint.isNotNull((Object)config, (String)"LDAPDirectory element cannot be null");
            this.configElement = config;
            this.logPrefix = prefix;
            if (AttributeSupport.hasAttribute((Element)config, (QName)new QName("mergeResults"))) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"mergeResults", (String)prefix, null);
            }
        }

        @Nonnull
        public BeanDefinition createConnectionConfig(@Nonnull ParserContext parserContext) {
            Mechanism mechanism;
            BeanDefinitionBuilder timeout;
            String url = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("ldapURL"));
            String useStartTLS = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("useStartTLS"));
            String principal = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("principal"));
            String principalCredential = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("principalCredential"));
            String authenticationType = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("authenticationType"));
            String connectTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("connectTimeout"));
            String responseTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("responseTimeout"));
            BeanDefinitionBuilder connectionConfig = BeanDefinitionBuilder.genericBeanDefinition(ConnectionConfig.class);
            connectionConfig.addPropertyValue("ldapUrl", (Object)url);
            if (useStartTLS != null) {
                connectionConfig.addPropertyValue("useStartTLS", (Object)useStartTLS);
            }
            if (connectTimeout != null) {
                timeout = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                timeout.addConstructorArgValue((Object)connectTimeout);
                timeout.addConstructorArgValue((Object)1);
                connectionConfig.addPropertyValue("connectTimeout", (Object)timeout.getBeanDefinition());
            } else {
                connectionConfig.addPropertyValue("connectTimeout", (Object)3000);
            }
            if (responseTimeout != null) {
                timeout = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                timeout.addConstructorArgValue((Object)responseTimeout);
                timeout.addConstructorArgValue((Object)1);
                connectionConfig.addPropertyValue("responseTimeout", (Object)timeout.getBeanDefinition());
            } else {
                connectionConfig.addPropertyValue("responseTimeout", (Object)3000);
            }
            BeanDefinitionBuilder sslConfig = BeanDefinitionBuilder.genericBeanDefinition(SslConfig.class);
            sslConfig.addPropertyValue("credentialConfig", (Object)this.createCredentialConfig(parserContext));
            connectionConfig.addPropertyValue("sslConfig", (Object)sslConfig.getBeanDefinition());
            BeanDefinitionBuilder connectionInitializer = BeanDefinitionBuilder.genericBeanDefinition(BindConnectionInitializer.class);
            if (principal != null) {
                connectionInitializer.addPropertyValue("bindDn", (Object)principal);
            }
            if (principalCredential != null) {
                BeanDefinitionBuilder credential = BeanDefinitionBuilder.genericBeanDefinition(Credential.class);
                credential.addConstructorArgValue((Object)principalCredential);
                connectionInitializer.addPropertyValue("bindCredential", (Object)credential.getBeanDefinition());
            }
            if (authenticationType != null && (mechanism = Mechanism.valueOf((String)authenticationType)) != null) {
                SaslConfig config = new SaslConfig();
                config.setMechanism(mechanism);
                connectionInitializer.addPropertyValue("bindSaslConfig", (Object)config);
            }
            if (principal != null || principalCredential != null || authenticationType != null) {
                connectionConfig.addPropertyValue("connectionInitializer", (Object)connectionInitializer.getBeanDefinition());
            }
            return connectionConfig.getBeanDefinition();
        }

        @Nonnull
        protected BeanDefinition createCredentialConfig(@Nonnull ParserContext parserContext) {
            BeanDefinitionBuilder result = BeanDefinitionBuilder.genericBeanDefinition(CredentialConfigFactoryBean.class);
            List trustElements = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "StartTLSTrustCredential"));
            trustElements.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "StartTLSTrustCredential")));
            String trustResource = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"trustFile"));
            if (trustResource != null) {
                if (!trustElements.isEmpty()) {
                    this.log.warn("{} StartTLSTrustCredential and trustFile= are incompatible.  trustFile used.", (Object)this.getLogPrefix());
                }
                BeanDefinitionBuilder credential = BeanDefinitionBuilder.genericBeanDefinition(BasicX509CredentialFactoryBean.class);
                credential.addPropertyValue("certificateResource", (Object)trustResource);
                result.addPropertyValue("trustCredential", (Object)credential.getBeanDefinition());
            } else if (!trustElements.isEmpty()) {
                if (trustElements.size() > 1) {
                    this.log.warn("{} Too many StartTLSTrustCredential elements in {}; only the first has been consulted", (Object)this.getLogPrefix(), (Object)parserContext.getReaderContext().getResource().getDescription());
                }
                result.addPropertyValue("trustCredential", SpringSupport.parseCustomElements((Collection)trustElements, (ParserContext)parserContext).get(0));
            }
            List authElements = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "StartTLSAuthenticationCredential"));
            authElements.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "StartTLSAuthenticationCredential")));
            String authKey = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"authKey"));
            String authCert = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"authCert"));
            if (authKey != null || authCert != null) {
                if (!authElements.isEmpty()) {
                    this.log.warn("{} StartTLSAuthenticationCredential and authKey/authCert= are incompatible.  authCert/authKey used.", (Object)this.getLogPrefix());
                }
                BeanDefinitionBuilder authCred = BeanDefinitionBuilder.genericBeanDefinition(BasicX509CredentialFactoryBean.class);
                authCred.addPropertyValue("certificateResource", (Object)authCert);
                authCred.addPropertyValue("privateKeyResource", (Object)authKey);
                authCred.addPropertyValue("privateKeyPassword", (Object)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"authKeyPassword"));
                result.addPropertyValue("authCredential", (Object)authCred.getBeanDefinition());
            } else if (!authElements.isEmpty()) {
                if (authElements.size() > 1) {
                    this.log.warn("{} Too many StartTLSAuthenticationCredential elements in {}; only the first has been consulted", (Object)this.getLogPrefix(), (Object)parserContext.getReaderContext().getResource().getDescription());
                }
                result.addPropertyValue("authCredential", SpringSupport.parseCustomElements((Collection)authElements, (ParserContext)parserContext).get(0));
            }
            return result.getBeanDefinition();
        }

        @Nullable
        private String getFilterText() {
            String filter;
            List filterElements = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "FilterTemplate"));
            filterElements.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "FilterTemplate")));
            if (!filterElements.isEmpty()) {
                if (filterElements.size() > 1) {
                    this.log.warn("{} only one <FilterTemplate> can be specified; only the first has been consulted", (Object)this.getLogPrefix());
                }
                filter = StringSupport.trimOrNull((String)((Element)filterElements.get(0)).getTextContent().trim());
            } else {
                filter = null;
            }
            return filter;
        }

        @Nullable
        public String getBeanSearchBuilderID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"executableSearchBuilderRef");
        }

        @Nonnull
        public BeanDefinition createTemplateBuilder() {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedExecutableSearchFilterBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttribute("templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            templateBuilder.addPropertyValue("v2Compatibility", (Object)true);
            templateBuilder.addPropertyValue("templateText", (Object)this.getFilterText());
            return templateBuilder.getBeanDefinition();
        }

        @Nonnull
        public BeanDefinition createSearchExecutor(ManagedMap<String, String> props) {
            String baseDn = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("baseDN"));
            String searchScope = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("searchScope"));
            String derefAliases = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("derefAliases"));
            String searchTimeLimit = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("searchTimeLimit"));
            String maxResultSize = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("maxResultSize"));
            String lowercaseAttributeNames = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("lowercaseAttributeNames"));
            BeanDefinitionBuilder searchExecutor = BeanDefinitionBuilder.genericBeanDefinition(SearchExecutor.class);
            if (baseDn != null) {
                searchExecutor.addPropertyValue("baseDn", (Object)baseDn);
            }
            if (searchScope != null) {
                searchExecutor.addPropertyValue("searchScope", (Object)searchScope);
            }
            if (derefAliases != null) {
                searchExecutor.addPropertyValue("derefAliases", (Object)derefAliases);
            } else if (props.containsKey((Object)"java.naming.ldap.derefAliases")) {
                searchExecutor.addPropertyValue("derefAliases", (Object)((String)props.get((Object)"java.naming.ldap.derefAliases")).toUpperCase());
            }
            if (searchTimeLimit != null) {
                BeanDefinitionBuilder duration = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                duration.addConstructorArgValue((Object)searchTimeLimit);
                duration.addConstructorArgValue((Object)1);
                searchExecutor.addPropertyValue("timeLimit", (Object)duration.getBeanDefinition());
            } else {
                searchExecutor.addPropertyValue("timeLimit", (Object)3000);
            }
            if (maxResultSize != null) {
                searchExecutor.addPropertyValue("sizeLimit", (Object)maxResultSize);
            } else {
                searchExecutor.addPropertyValue("sizeLimit", (Object)1);
            }
            BeanDefinitionBuilder handlers = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildSearchEntryHandlers");
            handlers.addConstructorArgValue((Object)lowercaseAttributeNames);
            searchExecutor.addPropertyValue("searchEntryHandlers", (Object)handlers.getBeanDefinition());
            List returnAttrsElements = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ReturnAttributes"));
            returnAttrsElements.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "ReturnAttributes")));
            if (!returnAttrsElements.isEmpty()) {
                if (returnAttrsElements.size() > 1) {
                    this.log.warn("{} Only one <ReturnAttributes> element can be specified; only the first has been consulted.", (Object)this.getLogPrefix());
                }
                Element returnAttrsElement = (Element)returnAttrsElements.get(0);
                BeanDefinitionBuilder returnAttrs = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildStringList");
                returnAttrs.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)returnAttrsElement));
                searchExecutor.addPropertyValue("returnAttributes", (Object)returnAttrs.getBeanDefinition());
            }
            List binaryAttrsElements = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "BinaryAttributes"));
            binaryAttrsElements.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "BinaryAttributes")));
            if (!binaryAttrsElements.isEmpty()) {
                if (binaryAttrsElements.size() > 1) {
                    this.log.warn("{} Only one <BinaryAttributes> element can be specified; only the first has been consulted.", (Object)this.getLogPrefix());
                }
                Element binaryAttrsElement = (Element)binaryAttrsElements.get(0);
                BeanDefinitionBuilder binaryAttrs = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildStringList");
                binaryAttrs.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)binaryAttrsElement));
                searchExecutor.addPropertyValue("binaryAttributes", (Object)binaryAttrs.getBeanDefinition());
            } else if (props.containsKey((Object)"java.naming.ldap.attributes.binary")) {
                BeanDefinitionBuilder binaryAttrs = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildStringList");
                binaryAttrs.addConstructorArgValue(props.get((Object)"java.naming.ldap.attributes.binary"));
                searchExecutor.addPropertyValue("binaryAttributes", (Object)binaryAttrs.getBeanDefinition());
            }
            return searchExecutor.getBeanDefinition();
        }

        @Nullable
        Element getConnectionPoolElement() {
            List poolConfigElements = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ConnectionPool"));
            poolConfigElements.addAll(ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "ConnectionPool")));
            if (poolConfigElements.isEmpty()) {
                return null;
            }
            if (poolConfigElements.size() > 1) {
                this.log.warn("{} Only one <ConnectionPool> should be specified; only the first has been consulted.", (Object)this.getLogPrefix());
            }
            return (Element)poolConfigElements.get(0);
        }

        @Nullable
        public BeanDefinition createConnectionPool(BeanDefinition connectionFactory) {
            Element poolConfigElement = this.getConnectionPoolElement();
            if (null == poolConfigElement) {
                return null;
            }
            String blockWaitTime = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("blockWaitTime"));
            String expirationTime = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("expirationTime"));
            BeanDefinitionBuilder pool = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildConnectionPool");
            pool.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("blockWhenEmpty")));
            if (blockWaitTime != null) {
                BeanDefinitionBuilder duration = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                duration.addConstructorArgValue((Object)blockWaitTime);
                duration.addConstructorArgValue((Object)1);
                pool.addPropertyValue("blockWaitTime", (Object)duration.getBeanDefinition());
            }
            if (expirationTime != null) {
                BeanDefinitionBuilder period = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                period.addConstructorArgValue((Object)expirationTime);
                period.addConstructorArgValue((Object)2000);
                BeanDefinitionBuilder idle = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                idle.addConstructorArgValue((Object)expirationTime);
                idle.addConstructorArgValue((Object)1000);
                BeanDefinitionBuilder strategy = BeanDefinitionBuilder.genericBeanDefinition(IdlePruneStrategy.class);
                strategy.addConstructorArgValue((Object)period.getBeanDefinition());
                strategy.addConstructorArgValue((Object)idle.getBeanDefinition());
                pool.addPropertyValue("pruneStrategy", (Object)strategy.getBeanDefinition());
            }
            pool.addPropertyValue("poolConfig", (Object)this.createPoolConfig());
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildSearchValidator");
            validator.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validatePeriodically")));
            validator.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateDN")));
            validator.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateFilter")));
            pool.addPropertyValue("validator", (Object)validator.getBeanDefinition());
            pool.addPropertyValue("connectionFactory", (Object)connectionFactory);
            String failFastInitialize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("failFastInitialize"));
            if (failFastInitialize != null) {
                pool.addPropertyValue("failFastInitialize", (Object)failFastInitialize);
            }
            pool.setInitMethodName("initialize");
            return pool.getBeanDefinition();
        }

        @Nullable
        protected BeanDefinition createPoolConfig() {
            Element poolConfigElement = this.getConnectionPoolElement();
            if (poolConfigElement == null) {
                return null;
            }
            String minPoolSize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("minPoolSize"));
            String maxPoolSize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("maxPoolSize"));
            String validatePeriodically = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validatePeriodically"));
            String validateTimerPeriod = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateTimerPeriod"));
            BeanDefinitionBuilder poolConfig = BeanDefinitionBuilder.genericBeanDefinition(PoolConfig.class);
            if (minPoolSize == null) {
                String poolInitialSize = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("poolInitialSize"));
                if (poolInitialSize != null) {
                    poolConfig.addPropertyValue("minPoolSize", (Object)poolInitialSize);
                } else {
                    poolConfig.addPropertyValue("minPoolSize", (Object)0);
                }
            } else {
                poolConfig.addPropertyValue("minPoolSize", (Object)minPoolSize);
            }
            if (maxPoolSize == null) {
                String poolMaxIdleSize = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("poolMaxIdleSize"));
                if (poolMaxIdleSize != null) {
                    poolConfig.addPropertyValue("maxPoolSize", (Object)poolMaxIdleSize);
                } else {
                    poolConfig.addPropertyValue("maxPoolSize", (Object)3);
                }
            } else {
                poolConfig.addPropertyValue("maxPoolSize", (Object)maxPoolSize);
            }
            if (validatePeriodically != null) {
                poolConfig.addPropertyValue("validatePeriodically", (Object)validatePeriodically);
            }
            if (validateTimerPeriod != null) {
                BeanDefinitionBuilder period = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                period.addConstructorArgValue((Object)validateTimerPeriod);
                period.addConstructorArgValue((Object)1000);
                poolConfig.addPropertyValue("validatePeriod", (Object)period.getBeanDefinition());
            } else {
                poolConfig.addPropertyValue("validatePeriod", (Object)1800);
            }
            return poolConfig.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createMappingStrategy() {
            String multipleResultsIsError;
            String noResultIsError;
            BeanDefinitionBuilder mapper = BeanDefinitionBuilder.genericBeanDefinition(StringAttributeValueMappingStrategy.class);
            List columns = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver:dc", (String)"Column");
            columns.addAll(ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"Column"));
            if (!columns.isEmpty()) {
                ManagedMap renamingMap = new ManagedMap();
                for (Element column : columns) {
                    String columnName = AttributeSupport.getAttributeValue((Element)column, null, (String)"columnName");
                    String attributeId = AttributeSupport.getAttributeValue((Element)column, null, (String)"attributeID");
                    if (columnName != null && attributeId != null) {
                        renamingMap.put((Object)columnName, (Object)attributeId);
                    }
                    if (!AttributeSupport.hasAttribute((Element)column, (QName)new QName("type"))) continue;
                    this.log.warn("{} Column type attribute not supported for LDAP results", (Object)this.getLogPrefix());
                }
                mapper.addPropertyValue("resultRenamingMap", (Object)renamingMap);
            }
            if ((noResultIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("noResultIsError"))) != null) {
                mapper.addPropertyValue("noResultAnError", (Object)noResultIsError);
            }
            if ((multipleResultsIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("multipleResultsIsError"))) != null) {
                mapper.addPropertyValue("multipleResultsAnError", (Object)multipleResultsIsError);
            }
            return mapper.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createValidator(BeanDefinition connectionFactory) {
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.genericBeanDefinition(ConnectionFactoryValidator.class);
            validator.addPropertyValue("connectionFactory", (Object)connectionFactory);
            return validator.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createCache(@Nonnull ParserContext parserContext) {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache(parserContext);
        }

        @Nonnull
        String getLogPrefix() {
            return this.logPrefix;
        }

        @Duration
        public static long buildDuration(@Duration long duration, long divisor) {
            return duration / divisor;
        }

        @Nonnull
        public static List<String> buildStringList(String value) {
            return StringSupport.stringToList((String)value, (String)" \n\r\t,");
        }

        @Nonnull
        public static BlockingConnectionPool buildConnectionPool(@Nullable String blockWhenEmpty) {
            Object pool = null;
            pool = blockWhenEmpty == null || Boolean.valueOf(blockWhenEmpty) != false ? new BlockingConnectionPool() : new SoftLimitConnectionPool();
            pool.setName("resolver-pool");
            return pool;
        }

        @Nullable
        public static SearchValidator buildSearchValidator(@Nullable String validatePeriodically, @Nullable String validateDN, @Nullable String validateFilter) {
            if (!Boolean.valueOf(validatePeriodically).booleanValue()) {
                return null;
            }
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.setReturnAttributes(new String[]{"1.1"});
            searchRequest.setSearchScope(SearchScope.OBJECT);
            searchRequest.setSizeLimit(1L);
            if (validateDN != null) {
                searchRequest.setBaseDn(validateDN);
            } else {
                searchRequest.setBaseDn("");
            }
            SearchFilter searchFilter = new SearchFilter();
            if (validateFilter != null) {
                searchFilter.setFilter(validateFilter);
            } else {
                searchFilter.setFilter("(objectClass=*)");
            }
            searchRequest.setSearchFilter(searchFilter);
            SearchValidator validator = new SearchValidator();
            validator.setSearchRequest(searchRequest);
            return validator;
        }

        @Nonnull
        public static List<SearchEntryHandler> buildSearchEntryHandlers(@Nullable String lowercaseAttributeNames) {
            ArrayList<SearchEntryHandler> handlers = new ArrayList<SearchEntryHandler>();
            handlers.add((SearchEntryHandler)new DnAttributeEntryHandler());
            if (Boolean.valueOf(lowercaseAttributeNames).booleanValue()) {
                CaseChangeEntryHandler entryHandler = new CaseChangeEntryHandler();
                entryHandler.setAttributeNameCaseChange(CaseChangeEntryHandler.CaseChange.LOWER);
                handlers.add((SearchEntryHandler)entryHandler);
            }
            return handlers;
        }
    }
}

