/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.SAML1NameIdentifierAttributeDefinitionParser;
import net.shibboleth.idp.saml.attribute.resolver.impl.SAML2NameIDAttributeDefinition;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SAML2NameIDAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "SAML2NameID");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML1NameIdentifierAttributeDefinitionParser.class);

    protected Class<SAML2NameIDAttributeDefinition> getBeanClass(@Nullable Element element) {
        return SAML2NameIDAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        if (config.hasAttributeNS(null, "nameIdFormat")) {
            String nameIdFormat = StringSupport.trimOrNull((String)config.getAttributeNS(null, "nameIdFormat"));
            builder.addPropertyValue("nameIdFormat", (Object)nameIdFormat);
            this.log.debug("{} nameIdFormat '{}'", (Object)this.getLogPrefix(), (Object)nameIdFormat);
        }
        String nameIdQualifier = StringSupport.trimOrNull((String)config.getAttributeNS(null, "nameIdQualifier"));
        builder.addPropertyValue("nameIdQualifier", (Object)nameIdQualifier);
        String nameIdSPQualifier = StringSupport.trimOrNull((String)config.getAttributeNS(null, "nameIdSPQualifier"));
        builder.addPropertyValue("nameIdSPQualifier", (Object)nameIdSPQualifier);
        this.log.debug("{} nameIdQualifier '{}', nameIdSPQualifier '{}'", new Object[]{this.getLogPrefix(), nameIdQualifier, nameIdSPQualifier});
    }
}

