/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.impl.ComputedPairwiseIdStore;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.PairwiseIdDataConnectorParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ComputedIdDataConnectorParser
extends PairwiseIdDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ComputedId");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ComputedIdDataConnectorParser.class);

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder, "computedId");
        builder.addPropertyValue("pairwiseIdStore", (Object)this.doComputedPairwiseIdStore(config, parserContext));
    }

    @Nonnull
    protected BeanDefinition doComputedPairwiseIdStore(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        String encodedSalt;
        String salt;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ComputedPairwiseIdStore.class);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        if (config.hasAttributeNS(null, "algorithm")) {
            builder.addPropertyValue("algorithm", (Object)config.getAttributeNS(null, "algorithm"));
        }
        if (config.hasAttributeNS(null, "encoding")) {
            builder.addPropertyValue("encoding", (Object)config.getAttributeNS(null, "encoding"));
        }
        if (config.hasAttributeNS(null, "exceptionMapRef")) {
            builder.addPropertyReference("exceptionMap", config.getAttributeNS(null, "exceptionMapRef"));
        }
        if (config.hasAttributeNS(null, "salt")) {
            salt = config.getAttributeNS(null, "salt");
            encodedSalt = null;
            if (config.hasAttributeNS(null, "encodedSalt")) {
                this.log.warn("{} Ignoring encodedSalt in favor of salt", (Object)this.getLogPrefix());
            }
        } else if (config.hasAttributeNS(null, "encodedSalt")) {
            salt = null;
            encodedSalt = config.getAttributeNS(null, "encodedSalt");
        } else {
            encodedSalt = null;
            salt = null;
        }
        if (salt != null) {
            this.log.debug("{} See TRACE log for the salt value", (Object)this.getLogPrefix());
            this.log.trace("{} Salt: '{}'", (Object)this.getLogPrefix(), (Object)salt);
            builder.addPropertyValue("salt", (Object)salt);
        } else if (encodedSalt != null) {
            this.log.debug("{} See TRACE log for the salt value", (Object)this.getLogPrefix());
            this.log.trace("{} Encoded Salt: '{}'", (Object)this.getLogPrefix(), (Object)encodedSalt);
            builder.addPropertyValue("encodedSalt", (Object)encodedSalt);
        } else {
            this.log.debug("{} No salt provided", (Object)this.getLogPrefix());
        }
        return builder.getBeanDefinition();
    }
}

