/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.enc;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.logic.ScriptedPredicate;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.ScriptTypeBeanParser;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseAttributeEncoderParser
extends AbstractSingleBeanDefinitionParser {
    @Nonnull
    @NotEmpty
    public static final String NAME_ATTRIBUTE_NAME = "name";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseAttributeEncoderParser.class);

    protected Class<TranscodingRule> getBeanClass(Element element) {
        return TranscodingRule.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected boolean shouldParseNameAsAliases() {
        return false;
    }

    protected void doParse(Element config, ParserContext context, BeanDefinitionBuilder builder) {
        ManagedMap rule = new ManagedMap();
        builder.addConstructorArgValue((Object)rule);
        Node parentAttribute = config.getParentNode();
        if (parentAttribute instanceof Element && ((Element)parentAttribute).hasAttributeNS(null, "id")) {
            List displayDescriptions;
            rule.put((Object)"id", (Object)StringSupport.trimOrNull((String)((Element)config.getParentNode()).getAttributeNS(null, "id")));
            List displayNames = ElementSupport.getChildElements((Node)parentAttribute, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "DisplayName"));
            if (displayNames != null && !displayNames.isEmpty()) {
                this.processLocalizedElement(displayNames, (ManagedMap<String, Object>)rule, "displayName");
            }
            if ((displayDescriptions = ElementSupport.getChildElements((Node)parentAttribute, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "DisplayDescription"))) != null && !displayDescriptions.isEmpty()) {
                this.processLocalizedElement(displayDescriptions, (ManagedMap<String, Object>)rule, "description");
            }
        } else {
            this.log.warn("Parsing AttributeEncoder with no parent element, resulting rule will be ignored");
        }
        if (config.hasAttributeNS(null, "activationConditionRef")) {
            if (config.hasAttributeNS(null, "relyingParties")) {
                this.log.warn("relyingParties ignored, using activationConditionRef");
            }
            rule.put((Object)"activationCondition", (Object)new RuntimeBeanReference(StringSupport.trimOrNull((String)config.getAttributeNS(null, "activationConditionRef"))));
        } else if (config.hasAttributeNS(null, "relyingParties")) {
            rule.put((Object)"relyingParties", (Object)config.getAttributeNS(null, "relyingParties"));
        } else {
            Element child = ElementSupport.getFirstChildElement((Node)config);
            if (child != null && ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:resolver", (String)"ActivationConditionScript")) {
                rule.put((Object)"activationCondition", (Object)ScriptTypeBeanParser.parseScriptType(ScriptedPredicate.class, (Element)child).getBeanDefinition());
            }
        }
        rule.put((Object)"transcoder", (Object)this.buildTranscoder());
        this.doParse(config, context, (Map<String, Object>)rule);
    }

    protected abstract void doParse(@Nonnull Element var1, @Nonnull ParserContext var2, @Nonnull Map<String, Object> var3);

    @Nonnull
    protected abstract BeanReference buildTranscoder();

    private void processLocalizedElement(@Nonnull List<Element> elements, @Nonnull ManagedMap<String, Object> rule, @Nonnull @NotEmpty String propertyPrefix) {
        for (Element element : elements) {
            String value = element.getTextContent();
            if (value == null) continue;
            String lang = StringSupport.trimOrNull((String)AttributeSupport.getXMLLang((Element)element));
            if (lang != null) {
                rule.put((Object)(propertyPrefix + "." + lang), (Object)value);
                continue;
            }
            rule.put((Object)propertyPrefix, (Object)value);
        }
    }
}

