/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class BaseAttributeDefinitionParser
extends BaseResolverPluginParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "AttributeDefinition");
    @Nonnull
    public static final QName ATTRIBUTE_ENCODER_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "AttributeEncoder");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseAttributeDefinitionParser.class);

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        if (config.hasAttributeNS(null, "dependencyOnly")) {
            String dependencyOnly = StringSupport.trimOrNull((String)config.getAttributeNS(null, "dependencyOnly"));
            this.log.debug("{} Setting dependencyOnly {}", (Object)this.getLogPrefix(), (Object)dependencyOnly);
            builder.addPropertyValue("dependencyOnly", (Object)dependencyOnly);
        }
        if (config.hasAttributeNS(null, "preRequested")) {
            String preRequested = StringSupport.trimOrNull((String)config.getAttributeNS(null, "preRequested"));
            this.log.debug("{} Setting preRequested {}", (Object)this.getLogPrefix(), (Object)preRequested);
            builder.addPropertyValue("preRequested", (Object)preRequested);
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Attribute Definition '").append(this.getDefinitionId()).append("':");
        return builder.toString();
    }
}

