/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScopedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ScopedAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "Scoped");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScopedAttributeDefinitionParser.class);

    protected Class<ScopedAttributeDefinition> getBeanClass(@Nullable Element element) {
        return ScopedAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String scopeSource;
        super.doParse(config, parserContext, builder);
        String scope = StringSupport.trimOrNull((String)config.getAttributeNS(null, "scope"));
        if (scope != null) {
            this.log.debug("{} Setting scope to '{}'.", (Object)this.getLogPrefix(), (Object)scope);
            builder.addPropertyValue("scope", (Object)scope);
        }
        if ((scopeSource = StringSupport.trimOrNull((String)config.getAttributeNS(null, "scopeFromDependency"))) != null) {
            this.log.debug("{} Setting scope source to '{}'.", (Object)this.getLogPrefix(), (Object)scopeSource);
            builder.addPropertyValue("scopeSource", (Object)scopeSource);
        }
    }
}

