/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.ldap.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.dc.ldap.StringAttributeValueMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ConnectionFactoryValidator;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.LDAPDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.V2CompatibleTemplatedExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.ldap.impl.CredentialConfigFactoryBean;
import net.shibboleth.idp.profile.spring.factory.BasicX509CredentialFactoryBean;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.ldaptive.ActivePassiveConnectionStrategy;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.RandomConnectionStrategy;
import org.ldaptive.RoundRobinConnectionStrategy;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.handler.CaseChangeEntryHandler;
import org.ldaptive.handler.DnAttributeEntryHandler;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.SearchValidator;
import org.ldaptive.referral.SearchReferralHandler;
import org.ldaptive.sasl.DigestMd5Config;
import org.ldaptive.sasl.GssApiConfig;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.ssl.AllowAnyHostnameVerifier;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.SslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LDAPDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "LDAPDirectory");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPDataConnectorParser.class);

    protected Class<LDAPDataConnector> getNativeBeanClass() {
        return LDAPDataConnector.class;
    }

    @Override
    protected void doV2Parse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        this.log.debug("{} Parsing XML configuration {}", (Object)this.getLogPrefix(), (Object)config);
        List oldProperties = ElementSupport.getChildElementsByTagNameNS((Node)config, (String)"urn:mace:shibboleth:2.0:resolver", (String)"LDAPProperty");
        for (Element oldProperty : oldProperties) {
            String oldPropName = oldProperty.getAttributeNS(null, "name");
            if ("com.sun.jndi.ldap.connect.timeout".equals(oldPropName)) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)("LDAPProperty " + oldPropName), (String)"LDAPConnector", (String)"LDAPConnector/@connectTimeout");
                continue;
            }
            if ("com.sun.jndi.ldap.read.timeout".equals(oldPropName)) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)("LDAPProperty " + oldPropName), (String)"LDAPConnector", (String)"LDAPConnector/@responseTimeout");
                continue;
            }
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)("LDAPProperty " + oldPropName), (String)"LDAPConnector", (String)"(replacement depends on property)");
        }
        V2Parser v2Parser = new V2Parser(config, this.getLogPrefix());
        BeanDefinitionBuilder connectionFactory = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.class);
        connectionFactory.addConstructorArgValue((Object)v2Parser.createConnectionConfig(parserContext));
        String searchBuilderID = v2Parser.getBeanSearchBuilderID();
        if (searchBuilderID != null) {
            builder.addPropertyReference("executableSearchBuilder", searchBuilderID);
        } else {
            BeanDefinition def = v2Parser.createTemplateBuilder();
            if (def != null) {
                builder.addPropertyValue("executableSearchBuilder", (Object)def);
            }
        }
        BeanDefinition connectionPool = v2Parser.createConnectionPool((BeanDefinition)connectionFactory.getBeanDefinition());
        BeanDefinitionBuilder pooledConnectionFactory = null;
        if (connectionPool != null) {
            pooledConnectionFactory = BeanDefinitionBuilder.genericBeanDefinition(PooledConnectionFactory.class);
            pooledConnectionFactory.addConstructorArgValue((Object)connectionPool);
            builder.addPropertyValue("connectionFactory", (Object)pooledConnectionFactory.getBeanDefinition());
        } else {
            builder.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
        }
        BeanDefinition searchExecutor = v2Parser.createSearchExecutor();
        builder.addPropertyValue("searchExecutor", (Object)searchExecutor);
        String mappingStrategyID = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("mappingStrategyRef"));
        if (mappingStrategyID != null) {
            builder.addPropertyReference("mappingStrategy", mappingStrategyID);
        } else {
            BeanDefinition def = v2Parser.createMappingStrategy();
            if (def != null) {
                builder.addPropertyValue("mappingStrategy", (Object)def);
            }
        }
        String validatorID = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("validatorRef"));
        if (validatorID != null) {
            builder.addPropertyReference("validator", validatorID);
        } else if (pooledConnectionFactory != null) {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator((BeanDefinition)pooledConnectionFactory.getBeanDefinition()));
        } else {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator((BeanDefinition)connectionFactory.getBeanDefinition()));
        }
        String resultCacheBeanID = CacheConfigParser.getBeanResultCacheID(config);
        if (null != resultCacheBeanID) {
            builder.addPropertyReference("resultsCache", resultCacheBeanID);
        } else {
            builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache(parserContext));
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected static class V2Parser {
        private static final Logger LOG = LoggerFactory.getLogger(V2Parser.class);
        private final Element configElement;
        private final String logPrefix;

        public V2Parser(@Nonnull Element config, @Nonnull String prefix) {
            Constraint.isNotNull((Object)config, (String)"LDAPDirectory element cannot be null");
            this.configElement = config;
            this.logPrefix = prefix;
        }

        @Nonnull
        public BeanDefinition createConnectionConfig(@Nonnull ParserContext parserContext) {
            String url = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("ldapURL"));
            String useStartTLS = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("useStartTLS"));
            String principal = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("principal"));
            String principalCredential = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("principalCredential"));
            String authenticationType = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("authenticationType"));
            String connectTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("connectTimeout"));
            String responseTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("responseTimeout"));
            BeanDefinitionBuilder connectionConfig = BeanDefinitionBuilder.genericBeanDefinition(ConnectionConfig.class);
            connectionConfig.addPropertyValue("ldapUrl", (Object)url);
            if (useStartTLS != null) {
                connectionConfig.addPropertyValue("useStartTLS", (Object)useStartTLS);
            }
            if (connectTimeout != null) {
                connectionConfig.addPropertyValue("connectTimeout", (Object)connectTimeout);
            } else {
                connectionConfig.addPropertyValue("connectTimeout", (Object)Duration.ofSeconds(3L));
            }
            if (responseTimeout != null) {
                connectionConfig.addPropertyValue("responseTimeout", (Object)responseTimeout);
            } else {
                connectionConfig.addPropertyValue("responseTimeout", (Object)Duration.ofSeconds(3L));
            }
            BeanDefinitionBuilder sslConfig = BeanDefinitionBuilder.genericBeanDefinition(SslConfig.class);
            String disableHostnameVerification = this.configElement.getAttributeNS(null, "disableHostnameVerification");
            if (disableHostnameVerification != null) {
                BeanDefinitionBuilder verifier = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildHostnameVerifier");
                verifier.addConstructorArgValue((Object)disableHostnameVerification);
                verifier.addConstructorArgValue((Object)this.getLogPrefix());
                sslConfig.addPropertyValue("hostnameVerifier", (Object)verifier.getBeanDefinition());
            }
            sslConfig.addPropertyValue("credentialConfig", (Object)this.createCredentialConfig(parserContext));
            connectionConfig.addPropertyValue("sslConfig", (Object)sslConfig.getBeanDefinition());
            BeanDefinitionBuilder connectionInitializer = BeanDefinitionBuilder.genericBeanDefinition(BindConnectionInitializer.class);
            if (principal != null) {
                connectionInitializer.addPropertyValue("bindDn", (Object)principal);
            }
            if (principalCredential != null) {
                BeanDefinitionBuilder credential = BeanDefinitionBuilder.genericBeanDefinition(Credential.class);
                credential.addConstructorArgValue((Object)principalCredential);
                connectionInitializer.addPropertyValue("bindCredential", (Object)credential.getBeanDefinition());
            }
            BeanDefinition saslConfig = null;
            if (authenticationType != null) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"authenticationType", (String)"<LDAPDirectory>", (String)"<SASLConfig>");
                Mechanism mechanism = Mechanism.valueOf((String)authenticationType);
                if ("ANONYMOUS".equals(authenticationType)) {
                    LOG.warn("{} Ignoring unsupported authenticationType {}. Do not set bind credentials for anonymous authentication", (Object)this.getLogPrefix(), (Object)mechanism);
                } else if ("STRONG".equals(authenticationType)) {
                    LOG.warn("{} Ignoring unsupported authenticationType {}.", (Object)this.getLogPrefix(), (Object)mechanism);
                } else if ("SIMPLE".equals(authenticationType)) {
                    LOG.warn("{} Ignoring unsupported authenticationType {}. Set bind credentials for simple authentication", (Object)this.getLogPrefix(), (Object)mechanism);
                } else {
                    BeanDefinitionBuilder saslConfigBuilder = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildSaslConfig");
                    saslConfigBuilder.addConstructorArgValue((Object)authenticationType);
                    saslConfig = saslConfigBuilder.getBeanDefinition();
                    connectionInitializer.addPropertyValue("bindSaslConfig", (Object)saslConfig);
                }
            } else {
                saslConfig = this.createSaslConfig();
                connectionInitializer.addPropertyValue("bindSaslConfig", (Object)saslConfig);
            }
            if (principal != null || principalCredential != null || saslConfig != null) {
                connectionConfig.addPropertyValue("connectionInitializer", (Object)connectionInitializer.getBeanDefinition());
            }
            String connectionStrategy = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("connectionStrategy"));
            BeanDefinitionBuilder connectionStrategyBuilder = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildConnectionStrategy");
            connectionStrategyBuilder.addConstructorArgValue((Object)connectionStrategy);
            connectionConfig.addPropertyValue("connectionStrategy", (Object)connectionStrategyBuilder.getBeanDefinition());
            return connectionConfig.getBeanDefinition();
        }

        @Nonnull
        protected BeanDefinition createCredentialConfig(@Nonnull ParserContext parserContext) {
            BeanDefinitionBuilder result = BeanDefinitionBuilder.genericBeanDefinition(CredentialConfigFactoryBean.class);
            List trustElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"StartTLSTrustCredential");
            String trustResource = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"trustFile"));
            if (trustResource != null) {
                if (!trustElements.isEmpty()) {
                    LOG.warn("{} StartTLSTrustCredential and trustFile= are incompatible.  trustFile used.", (Object)this.getLogPrefix());
                }
                BeanDefinitionBuilder credential = BeanDefinitionBuilder.genericBeanDefinition(BasicX509CredentialFactoryBean.class);
                credential.addPropertyValue("certificateResource", (Object)trustResource);
                result.addPropertyValue("trustCredential", (Object)credential.getBeanDefinition());
            } else if (!trustElements.isEmpty()) {
                if (trustElements.size() > 1) {
                    LOG.warn("{} Too many StartTLSTrustCredential elements in {}; only the first has been consulted", (Object)this.getLogPrefix(), (Object)parserContext.getReaderContext().getResource().getDescription());
                }
                result.addPropertyValue("trustCredential", (Object)SpringSupport.parseCustomElement((Element)((Element)trustElements.get(0)), (ParserContext)parserContext, (BeanDefinitionBuilder)result, (boolean)false));
            }
            List authElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"StartTLSAuthenticationCredential");
            String authKey = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"authKey"));
            String authCert = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"authCert"));
            if (authKey != null || authCert != null) {
                if (!authElements.isEmpty()) {
                    LOG.warn("{} StartTLSAuthenticationCredential and authKey/authCert= are incompatible.  authCert/authKey used.", (Object)this.getLogPrefix());
                }
                BeanDefinitionBuilder authCred = BeanDefinitionBuilder.genericBeanDefinition(BasicX509CredentialFactoryBean.class);
                authCred.addPropertyValue("certificateResource", (Object)authCert);
                authCred.addPropertyValue("privateKeyResource", (Object)authKey);
                authCred.addPropertyValue("privateKeyPassword", (Object)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"authKeyPassword"));
                result.addPropertyValue("authCredential", (Object)authCred.getBeanDefinition());
            } else if (!authElements.isEmpty()) {
                if (authElements.size() > 1) {
                    LOG.warn("{} Too many StartTLSAuthenticationCredential elements in {}; only the first has been consulted", (Object)this.getLogPrefix(), (Object)parserContext.getReaderContext().getResource().getDescription());
                }
                result.addPropertyValue("authCredential", (Object)SpringSupport.parseCustomElement((Element)((Element)authElements.get(0)), (ParserContext)parserContext, (BeanDefinitionBuilder)result, (boolean)false));
            }
            return result.getBeanDefinition();
        }

        @Nullable
        private String getFilterText() {
            String filter;
            List filterElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"FilterTemplate");
            if (!filterElements.isEmpty()) {
                if (filterElements.size() > 1) {
                    LOG.warn("{} only one <FilterTemplate> can be specified; only the first has been consulted", (Object)this.getLogPrefix());
                }
                filter = StringSupport.trimOrNull((String)((Element)filterElements.get(0)).getTextContent().trim());
            } else {
                filter = null;
            }
            return filter;
        }

        @Nullable
        public String getBeanSearchBuilderID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"executableSearchBuilderRef");
        }

        @Nonnull
        public BeanDefinition createTemplateBuilder() {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(V2CompatibleTemplatedExecutableSearchFilterBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttribute("templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            templateBuilder.addPropertyValue("v2Compatibility", (Object)true);
            templateBuilder.addPropertyValue("templateText", (Object)this.getFilterText());
            return templateBuilder.getBeanDefinition();
        }

        @Nonnull
        public BeanDefinition createSearchExecutor() {
            List binaryAttrsElements;
            String baseDn = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("baseDN"));
            String searchScope = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("searchScope"));
            String derefAliases = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("derefAliases"));
            String followReferrals = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("followReferrals"));
            String searchTimeLimit = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("searchTimeLimit"));
            String maxResultSize = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("maxResultSize"));
            String lowercaseAttributeNames = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("lowercaseAttributeNames"));
            BeanDefinitionBuilder searchExecutor = BeanDefinitionBuilder.genericBeanDefinition(SearchExecutor.class);
            if (baseDn != null) {
                searchExecutor.addPropertyValue("baseDn", (Object)baseDn);
            }
            if (searchScope != null) {
                searchExecutor.addPropertyValue("searchScope", (Object)searchScope);
            }
            if (derefAliases != null) {
                searchExecutor.addPropertyValue("derefAliases", (Object)derefAliases);
            }
            if (followReferrals != null) {
                BeanDefinitionBuilder handler = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildReferralHandler");
                handler.addConstructorArgValue((Object)followReferrals);
                searchExecutor.addPropertyValue("referralHandler", (Object)handler.getBeanDefinition());
            }
            if (searchTimeLimit != null) {
                searchExecutor.addPropertyValue("timeLimit", (Object)searchTimeLimit);
            } else {
                searchExecutor.addPropertyValue("timeLimit", (Object)Duration.ofSeconds(3L));
            }
            if (maxResultSize != null) {
                searchExecutor.addPropertyValue("sizeLimit", (Object)maxResultSize);
            } else {
                searchExecutor.addPropertyValue("sizeLimit", (Object)1);
            }
            BeanDefinitionBuilder handlers = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildSearchEntryHandlers");
            handlers.addConstructorArgValue((Object)lowercaseAttributeNames);
            searchExecutor.addPropertyValue("searchEntryHandlers", (Object)handlers.getBeanDefinition());
            List returnAttrsElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"ReturnAttributes");
            if (!returnAttrsElements.isEmpty()) {
                if (returnAttrsElements.size() > 1) {
                    LOG.warn("{} Only one <ReturnAttributes> element can be specified; only the first has been consulted.", (Object)this.getLogPrefix());
                }
                Element returnAttrsElement = (Element)returnAttrsElements.get(0);
                BeanDefinitionBuilder returnAttrs = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildStringList");
                returnAttrs.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)returnAttrsElement));
                searchExecutor.addPropertyValue("returnAttributes", (Object)returnAttrs.getBeanDefinition());
            }
            if (!(binaryAttrsElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"BinaryAttributes")).isEmpty()) {
                if (binaryAttrsElements.size() > 1) {
                    LOG.warn("{} Only one <BinaryAttributes> element can be specified; only the first has been consulted.", (Object)this.getLogPrefix());
                }
                Element binaryAttrsElement = (Element)binaryAttrsElements.get(0);
                BeanDefinitionBuilder binaryAttrs = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildStringList");
                binaryAttrs.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)binaryAttrsElement));
                searchExecutor.addPropertyValue("binaryAttributes", (Object)binaryAttrs.getBeanDefinition());
            }
            return searchExecutor.getBeanDefinition();
        }

        @Nullable
        Element getConnectionPoolElement() {
            List poolConfigElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"ConnectionPool");
            if (poolConfigElements.isEmpty()) {
                return null;
            }
            if (poolConfigElements.size() > 1) {
                LOG.warn("{} Only one <ConnectionPool> should be specified; only the first has been consulted.", (Object)this.getLogPrefix());
            }
            return (Element)poolConfigElements.get(0);
        }

        @Nullable
        public BeanDefinition createConnectionPool(BeanDefinition connectionFactory) {
            Element poolConfigElement = this.getConnectionPoolElement();
            if (null == poolConfigElement) {
                return null;
            }
            if (poolConfigElement.hasAttributeNS(null, "blockWhenEmpty")) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"blockWhenEmpty", (String)"<ConnectionPool>", (String)"(none), will be ignored");
            }
            String blockWaitTime = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("blockWaitTime"));
            String expirationTime = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("expirationTime"));
            BeanDefinitionBuilder pool = BeanDefinitionBuilder.genericBeanDefinition(BlockingConnectionPool.class);
            pool.addPropertyValue("name", (Object)"resolver-pool");
            if (blockWaitTime != null) {
                pool.addPropertyValue("blockWaitTime", (Object)blockWaitTime);
            }
            if (expirationTime != null) {
                BeanDefinitionBuilder strategy = BeanDefinitionBuilder.genericBeanDefinition(IdlePruneStrategy.class);
                strategy.addConstructorArgValue((Object)expirationTime);
                pool.addPropertyValue("pruneStrategy", (Object)strategy.getBeanDefinition());
            }
            pool.addPropertyValue("poolConfig", (Object)this.createPoolConfig());
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildSearchValidator");
            validator.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validatePeriodically")));
            validator.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateDN")));
            validator.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateFilter")));
            pool.addPropertyValue("validator", (Object)validator.getBeanDefinition());
            pool.addPropertyValue("connectionFactory", (Object)connectionFactory);
            String failFastInitialize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("failFastInitialize"));
            if (failFastInitialize != null) {
                DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"failfastInitialize (on a ConnectionPool element)", null, (String)"failfastInitialize (on a DataConnector)");
                pool.addPropertyValue("failFastInitialize", (Object)failFastInitialize);
            } else if (this.configElement.hasAttributeNS(null, "failFastInitialize")) {
                pool.addPropertyValue("failFastInitialize", (Object)StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "failFastInitialize")));
            }
            pool.setInitMethodName("initialize");
            return pool.getBeanDefinition();
        }

        @Nullable
        protected BeanDefinition createPoolConfig() {
            Element poolConfigElement = this.getConnectionPoolElement();
            if (poolConfigElement == null) {
                return null;
            }
            String minPoolSize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("minPoolSize"));
            String maxPoolSize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("maxPoolSize"));
            String validatePeriodically = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validatePeriodically"));
            String validateTimerPeriod = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateTimerPeriod"));
            BeanDefinitionBuilder poolConfig = BeanDefinitionBuilder.genericBeanDefinition(PoolConfig.class);
            if (minPoolSize == null) {
                poolConfig.addPropertyValue("minPoolSize", (Object)0);
            } else {
                poolConfig.addPropertyValue("minPoolSize", (Object)minPoolSize);
            }
            if (maxPoolSize == null) {
                poolConfig.addPropertyValue("maxPoolSize", (Object)3);
            } else {
                poolConfig.addPropertyValue("maxPoolSize", (Object)maxPoolSize);
            }
            if (validatePeriodically != null) {
                poolConfig.addPropertyValue("validatePeriodically", (Object)validatePeriodically);
            }
            if (validateTimerPeriod != null) {
                poolConfig.addPropertyValue("validatePeriod", (Object)validateTimerPeriod);
            } else {
                poolConfig.addPropertyValue("validatePeriod", (Object)Duration.ofMinutes(30L));
            }
            return poolConfig.getBeanDefinition();
        }

        @Nullable
        protected BeanDefinition createSaslConfig() {
            BeanDefinitionBuilder saslConfig;
            List saslConfigElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"SASLConfig");
            if (saslConfigElements.isEmpty()) {
                return null;
            }
            if (saslConfigElements.size() > 1) {
                LOG.warn("{} Only one <SASLConfig> element can be specified; only the first has been consulted.", (Object)this.getLogPrefix());
            }
            Element saslConfigElement = (Element)saslConfigElements.get(0);
            String mechanism = AttributeSupport.getAttributeValue((Element)saslConfigElement, (QName)new QName("mechanism"));
            String authorizationId = AttributeSupport.getAttributeValue((Element)saslConfigElement, (QName)new QName("authorizationId"));
            String realm = AttributeSupport.getAttributeValue((Element)saslConfigElement, (QName)new QName("realm"));
            List saslProperties = ElementSupport.getChildElementsByTagNameNS((Node)saslConfigElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"SASLProperty");
            if ("DIGEST_MD5".equals(mechanism)) {
                saslConfig = BeanDefinitionBuilder.genericBeanDefinition(DigestMd5Config.class);
                if (realm != null) {
                    saslConfig.addPropertyValue("realm", (Object)realm);
                }
            } else if ("GSSAPI".equals(mechanism)) {
                saslConfig = BeanDefinitionBuilder.genericBeanDefinition(GssApiConfig.class);
                if (realm != null) {
                    saslConfig.addPropertyValue("realm", (Object)realm);
                }
            } else {
                saslConfig = BeanDefinitionBuilder.genericBeanDefinition(SaslConfig.class);
                saslConfig.addPropertyValue("mechanism", (Object)mechanism);
            }
            if (authorizationId != null) {
                saslConfig.addPropertyValue("authorizationId", (Object)authorizationId);
            }
            if (!saslProperties.isEmpty()) {
                for (Element property : saslProperties) {
                    String name = AttributeSupport.getAttributeValue((Element)property, null, (String)"name");
                    String value = AttributeSupport.getAttributeValue((Element)property, null, (String)"value");
                    if ("javax.security.sasl.qop".equals(name)) {
                        if ("auth".equalsIgnoreCase(value)) {
                            saslConfig.addPropertyValue("qualityOfProtection", (Object)"AUTH");
                            continue;
                        }
                        if ("auth-int".equalsIgnoreCase(value)) {
                            saslConfig.addPropertyValue("qualityOfProtection", (Object)"AUTH_INT");
                            continue;
                        }
                        if ("auth-conf".equalsIgnoreCase(value)) {
                            saslConfig.addPropertyValue("qualityOfProtection", (Object)"AUTH_CONF");
                            continue;
                        }
                        saslConfig.addPropertyValue("qualityOfProtection", (Object)value);
                        continue;
                    }
                    if ("javax.security.sasl.strength".equals(name)) {
                        saslConfig.addPropertyValue("securityStrength", (Object)value);
                        continue;
                    }
                    if (!"javax.security.sasl.server.authentication".equals(name)) continue;
                    saslConfig.addPropertyValue("mutualAuthentication", (Object)value);
                }
            }
            return saslConfig.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createMappingStrategy() {
            String multipleResultsIsError;
            String noResultIsError;
            BeanDefinitionBuilder mapper = BeanDefinitionBuilder.genericBeanDefinition(StringAttributeValueMappingStrategy.class);
            List columns = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"Column");
            if (!columns.isEmpty()) {
                ManagedMap renamingMap = new ManagedMap();
                for (Element column : columns) {
                    String columnName = AttributeSupport.getAttributeValue((Element)column, null, (String)"columnName");
                    String attributeId = AttributeSupport.getAttributeValue((Element)column, null, (String)"attributeID");
                    if (columnName == null || attributeId == null) continue;
                    renamingMap.put((Object)columnName, (Object)attributeId);
                }
                mapper.addPropertyValue("resultRenamingMap", (Object)renamingMap);
            }
            if ((noResultIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("noResultIsError"))) != null) {
                mapper.addPropertyValue("noResultAnError", (Object)SpringSupport.getStringValueAsBoolean((String)noResultIsError));
            }
            if ((multipleResultsIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("multipleResultsIsError"))) != null) {
                mapper.addPropertyValue("multipleResultsAnError", (Object)multipleResultsIsError);
            }
            return mapper.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createValidator(BeanDefinition connectionFactory) {
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.genericBeanDefinition(ConnectionFactoryValidator.class);
            validator.addPropertyValue("connectionFactory", (Object)connectionFactory);
            return validator.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createCache(@Nonnull ParserContext parserContext) {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache(parserContext);
        }

        @Nonnull
        String getLogPrefix() {
            return this.logPrefix;
        }

        @Nonnull
        public static List<String> buildStringList(String value) {
            return StringSupport.stringToList((String)value, (String)" \n\r\t,");
        }

        @Nullable
        public static SearchValidator buildSearchValidator(@Nullable String validatePeriodically, @Nullable String validateDN, @Nullable String validateFilter) {
            if (!Boolean.valueOf(validatePeriodically).booleanValue()) {
                return null;
            }
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.setReturnAttributes(new String[]{"1.1"});
            searchRequest.setSearchScope(SearchScope.OBJECT);
            searchRequest.setSizeLimit(1L);
            if (validateDN != null) {
                searchRequest.setBaseDn(validateDN);
            } else {
                searchRequest.setBaseDn("");
            }
            SearchFilter searchFilter = new SearchFilter();
            if (validateFilter != null) {
                searchFilter.setFilter(validateFilter);
            } else {
                searchFilter.setFilter("(objectClass=*)");
            }
            searchRequest.setSearchFilter(searchFilter);
            SearchValidator validator = new SearchValidator();
            validator.setSearchRequest(searchRequest);
            return validator;
        }

        @Nullable
        public static CertificateHostnameVerifier buildHostnameVerifier(@Nullable String disableHostnameVerification, @Nullable String logPrefix) {
            if (disableHostnameVerification != null && Boolean.valueOf(disableHostnameVerification).booleanValue()) {
                LoggerFactory.getLogger(LDAPDataConnectorParser.class).warn("{} TLS server certificate name checking is disabled!", (Object)logPrefix);
                return new AllowAnyHostnameVerifier();
            }
            return null;
        }

        @Nonnull
        public static List<SearchEntryHandler> buildSearchEntryHandlers(@Nullable String lowercaseAttributeNames) {
            ArrayList<SearchEntryHandler> handlers = new ArrayList<SearchEntryHandler>();
            handlers.add((SearchEntryHandler)new DnAttributeEntryHandler());
            if (Boolean.valueOf(lowercaseAttributeNames).booleanValue()) {
                CaseChangeEntryHandler entryHandler = new CaseChangeEntryHandler();
                entryHandler.setAttributeNameCaseChange(CaseChangeEntryHandler.CaseChange.LOWER);
                handlers.add((SearchEntryHandler)entryHandler);
            }
            return handlers;
        }

        @Nonnull
        public static SearchReferralHandler buildReferralHandler(@Nullable String followReferrals) {
            if (followReferrals != null && Boolean.valueOf(followReferrals).booleanValue()) {
                return new SearchReferralHandler();
            }
            return null;
        }

        @Nonnull
        public static SaslConfig buildSaslConfig(@Nonnull String mechanism) {
            SaslConfig config = new SaslConfig();
            config.setMechanism(Mechanism.valueOf((String)mechanism));
            return config;
        }

        @Nonnull
        public static ConnectionStrategy buildConnectionStrategy(@Nonnull String connectionStrategy) {
            if (connectionStrategy == null) {
                return new ActivePassiveConnectionStrategy();
            }
            switch (connectionStrategy) {
                case "ROUND_ROBIN": {
                    return new RoundRobinConnectionStrategy();
                }
                case "RANDOM": {
                    return new RandomConnectionStrategy();
                }
                case "ACTIVE_PASSIVE": {
                    return new ActivePassiveConnectionStrategy();
                }
                case "DEFAULT": {
                    DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"connectionStrategy=DEFAULT", (String)"LDAP Connector", (String)"ACTIVE_PASSIVE");
                    return new ActivePassiveConnectionStrategy();
                }
            }
            LOG.warn("Unexpected connectionStrategy {}", (Object)connectionStrategy);
            return new ActivePassiveConnectionStrategy();
        }
    }
}

