/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.ad.impl.ContextDerivedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ad.impl.IdPAttributePrincipalValuesFunction;
import net.shibboleth.idp.attribute.resolver.ad.impl.SubjectDerivedAttributeValuesFunction;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SubjectDerivedAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "SubjectDerivedAttribute");
    private final Logger log = LoggerFactory.getLogger(SubjectDerivedAttributeDefinitionParser.class);

    protected Class<ContextDerivedAttributeDefinition> getBeanClass(Element element) {
        return ContextDerivedAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String attributeName = StringSupport.trimOrNull((String)config.getAttributeNS(null, "principalAttributeName"));
        String functionRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "attributeValuesFunctionRef"));
        BeanDefinitionBuilder contextFunctionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SubjectDerivedAttributeValuesFunction.class);
        contextFunctionBuilder.setInitMethodName("initialize");
        contextFunctionBuilder.setDestroyMethodName("destroy");
        contextFunctionBuilder.addPropertyValue("id", (Object)this.getDefinitionId());
        if (config.hasAttributeNS(null, "forCanonicalization")) {
            contextFunctionBuilder.addPropertyValue("forCanonicalization", (Object)SpringSupport.getStringValueAsBoolean((String)config.getAttributeNS(null, "forCanonicalization")));
        }
        if (null != attributeName) {
            if (null != functionRef) {
                this.log.warn("{} only one of \"principalAttributeName\" or \"attributeValuesFunctionRef\" should be provided. \"attributeValuesFunctionRef\" ignored", (Object)this.getLogPrefix());
            }
            BeanDefinitionBuilder principalValuesFunctionBuilder = BeanDefinitionBuilder.genericBeanDefinition(IdPAttributePrincipalValuesFunction.class);
            principalValuesFunctionBuilder.addPropertyValue("attributeName", (Object)attributeName);
            contextFunctionBuilder.addPropertyValue("attributeValuesFunction", (Object)principalValuesFunctionBuilder.getBeanDefinition());
        } else if (null != functionRef) {
            contextFunctionBuilder.addPropertyReference("attributeValuesFunction", functionRef);
        } else {
            this.log.error("{} one of \"principalAttributeName\" or \"attributeValuesFunctionRef\" should be supplied. should be provided.", (Object)this.getLogPrefix());
            throw new BeanCreationException("Misconfigured PrincipalDerivedAttribute.");
        }
        builder.addPropertyValue("attributeValuesFunction", (Object)contextFunctionBuilder.getBeanDefinition());
    }

    @Override
    protected boolean failOnDependencies() {
        return true;
    }
}

