/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.dc.impl.SubjectDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.impl.AttributeResolverNamespaceHandler;

/** Bean definition Parser for a {@link SubjectDataConnector}. */
public class SubjectDataConnectorParser extends AbstractDataConnectorParser {

    /** Schema type - resolver. */
    @Nonnull public static final QName TYPE_NAME_RESOLVER =
            new QName(AttributeResolverNamespaceHandler.NAMESPACE, "Subject");

    /** {@inheritDoc} */
    @Override protected Class<SubjectDataConnector> getNativeBeanClass() {
        return SubjectDataConnector.class;
    }

    /** {@inheritDoc} */
    @Override protected void doV2Parse(@Nonnull final Element config, @Nonnull final ParserContext parserContext,
            @Nonnull final BeanDefinitionBuilder builder) {
        
        if (config.hasAttributeNS(null, "noResultIsError")) {
            builder.addPropertyValue("noResultIsError",
                    SpringSupport.getStringValueAsBoolean(config.getAttributeNS(null, "noResultIsError")));
        }
        
        if (config.hasAttributeNS(null, "forCanonicalization")) {
            builder.addPropertyValue("forCanonicalization",
                    SpringSupport.getStringValueAsBoolean(config.getAttributeNS(null, "forCanonicalization")));
        }
    }

    /** {@inheritDoc} */
    @Override protected boolean warnOnDependencies() {
        return true;
    }

}