/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.config.StringToDurationConverter;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ManagedConnectionParser;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CacheConfigParser {
    @Nonnull
    public static final QName RESULT_CACHE_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ResultCache");
    @Nonnull
    public static final QName RESULT_CACHE_BEAN_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "ResultCacheBean");
    public static final long DEFAULT_CACHE_ENTRIES = 500L;
    @Nonnull
    public static final Duration DEFAULT_TTL_MS = Duration.ofHours(4L);
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CacheConfigParser.class);
    @Nonnull
    private final Element configElement;

    public CacheConfigParser(@Nonnull Element config) {
        Constraint.isNotNull((Object)config, (String)"Element cannot be null");
        this.configElement = config;
    }

    @Nonnull
    public BeanDefinition createCache(@Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder cache;
        List cacheElements = ElementSupport.getChildElements((Node)this.configElement, (QName)RESULT_CACHE_RESOLVER);
        if (cacheElements.isEmpty()) {
            return null;
        }
        if (cacheElements.size() > 1) {
            this.log.warn("Only one <ResultCache> element can be specified, the first one has been taken");
        }
        Element cacheElement = (Element)cacheElements.get(0);
        String expireAfterWrite = AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("expireAfterWrite"));
        String expireAfterAccess = AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("expireAfterAccess"));
        if (expireAfterWrite != null) {
            if (null != expireAfterAccess) {
                this.log.warn("ResultCache: Attribute 'expireAfterAccess' is mutually exclusive with 'expireAfterWrite'. Used 'expireAfterWrite'.");
            }
            cache = BeanDefinitionBuilder.rootBeanDefinition(CacheConfigParser.class, (String)"buildCacheWrite");
            cache.addConstructorArgValue((Object)expireAfterWrite);
        } else {
            cache = BeanDefinitionBuilder.rootBeanDefinition(CacheConfigParser.class, (String)"buildCacheAccess");
            cache.addConstructorArgValue((Object)expireAfterAccess);
        }
        cache.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("maximumCachedElements")));
        return cache.getBeanDefinition();
    }

    private static long getMaxSize(@Nullable String maximumSize) {
        if (maximumSize != null) {
            return Long.parseLong(maximumSize);
        }
        return 500L;
    }

    @Nonnull
    private static Duration getTimeToLive(@Nullable String timeToLive) {
        if (timeToLive != null) {
            return new StringToDurationConverter().convert(timeToLive);
        }
        return DEFAULT_TTL_MS;
    }

    @Nullable
    public static Cache<String, Map<String, IdPAttribute>> buildCacheAccess(@Nullable String timeToLive, @Nullable String maximumSize) {
        return CacheBuilder.newBuilder().maximumSize(CacheConfigParser.getMaxSize(maximumSize)).expireAfterAccess(CacheConfigParser.getTimeToLive(timeToLive).toMillis(), TimeUnit.MILLISECONDS).build();
    }

    @Nullable
    public static Cache<String, Map<String, IdPAttribute>> buildCacheWrite(@Nullable String timeToLive, @Nullable String maximumSize) {
        return CacheBuilder.newBuilder().maximumSize(CacheConfigParser.getMaxSize(maximumSize)).expireAfterWrite(CacheConfigParser.getTimeToLive(timeToLive).toMillis(), TimeUnit.MILLISECONDS).build();
    }

    @Nullable
    public static String getBeanResultCacheID(@Nonnull Element config) {
        List resultCacheElements;
        List beanResultCache = ElementSupport.getChildElements((Node)config, (QName)RESULT_CACHE_BEAN_RESOLVER);
        if (beanResultCache.isEmpty()) {
            return null;
        }
        if (beanResultCache.size() > 1) {
            LoggerFactory.getLogger(ManagedConnectionParser.class).warn("Only one <ResultCacheBean> should be specified; the first one has been consulted");
        }
        if ((resultCacheElements = ElementSupport.getChildElements((Node)config, (QName)RESULT_CACHE_RESOLVER)).size() > 0) {
            LoggerFactory.getLogger(ManagedConnectionParser.class).warn("<ResultCacheBean> is incompatible with <ResultCache>. The <ResultCacheBean> has been used");
        }
        return StringSupport.trimOrNull((String)ElementSupport.getElementContentAsString((Element)((Element)beanResultCache.get(0))));
    }
}

