/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.impl.JDBCPairwiseIdStore;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ComputedIdDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ManagedConnectionParser;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class StoredIdDataConnectorParser
extends ComputedIdDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "StoredId");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredIdDataConnectorParser.class);

    @Override
    protected void doV2Parse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder, "storedId");
        builder.addPropertyValue("pairwiseIdStore", (Object)this.doJDBCPairwiseIdStore(config, parserContext));
    }

    @Nonnull
    protected BeanDefinition doJDBCPairwiseIdStore(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JDBCPairwiseIdStore.class);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        String beanDataSource = ManagedConnectionParser.getBeanDataSourceID(config);
        if (beanDataSource != null) {
            builder.addPropertyReference("dataSource", beanDataSource);
        } else {
            builder.addPropertyValue("dataSource", (Object)this.getv2DataSource(config));
        }
        if (config.hasAttributeNS(null, "queryTimeout")) {
            builder.addPropertyValue("queryTimeout", (Object)config.getAttributeNS(null, "queryTimeout"));
        }
        if (config.hasAttributeNS(null, "transactionRetries")) {
            builder.addPropertyValue("transactionRetries", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "transactionRetries")));
        }
        if (config.hasAttributeNS(null, "tableName")) {
            builder.addPropertyValue("tableName", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "tableName")));
        }
        if (config.hasAttributeNS(null, "failFast")) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"failFast", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"failFastInitialize");
            builder.addPropertyValue("verifyDatabase", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "failFast")));
        }
        if (config.hasAttributeNS(null, "failFastInitialize")) {
            builder.addPropertyValue("verifyDatabase", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "failFastInitialize")));
        }
        if (config.hasAttributeNS(null, "retryableErrors")) {
            builder.addPropertyValue("retryableErrors", (Object)SpringSupport.getAttributeValueAsList((Attr)config.getAttributeNodeNS(null, "retryableErrors")));
        }
        if (config.hasAttributeNS(null, "salt") || config.hasAttributeNS(null, "encodedSalt") || config.hasAttributeNS(null, "saltLookupStrategyRef")) {
            builder.addPropertyValue("initialValueStore", (Object)this.doComputedPairwiseIdStore(config, parserContext));
        }
        return builder.getBeanDefinition();
    }

    protected BeanDefinition getv2DataSource(@Nonnull Element config) {
        this.log.debug("{} Parsing v2 configuration", (Object)this.getLogPrefix());
        ManagedConnectionParser parser = new ManagedConnectionParser(config);
        return parser.createDataSource();
    }
}

