/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.mapped.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.AbstractCustomBeanDefinitionParser;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.SourceValue;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SourceValueParser
extends AbstractCustomBeanDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME_RESOLVER = new QName("urn:mace:shibboleth:2.0:resolver", "SourceValue");
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SourceValueParser.class);

    protected Class<SourceValue> getBeanClass(@Nullable Element element) {
        return SourceValue.class;
    }

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        String value = config.getTextContent();
        builder.addPropertyValue("value", (Object)value);
        String caseSensitive = null;
        if (config.hasAttributeNS(null, "caseSensitive")) {
            caseSensitive = StringSupport.trimOrNull((String)config.getAttributeNS(null, "caseSensitive"));
            builder.addPropertyValue("caseSensitive", (Object)SpringSupport.getStringValueAsBoolean((String)caseSensitive));
            if (config.hasAttributeNS(null, "ignoreCase")) {
                this.log.warn("{}: Both \"caseSensitive\" and \"ignoreCase\" specified, only the former will be used", (Object)parserContext.getReaderContext().getResource().getDescription());
            }
        } else if (config.hasAttributeNS(null, "ignoreCase")) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)"ignoreCase", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"caseSensitive");
            builder.addPropertyValue("ignoreCase", (Object)SpringSupport.getStringValueAsBoolean((String)config.getAttributeNS(null, "ignoreCase")));
        }
        String partialMatch = null;
        if (config.hasAttributeNS(null, "partialMatch")) {
            partialMatch = StringSupport.trimOrNull((String)config.getAttributeNS(null, "partialMatch"));
            builder.addPropertyValue("partialMatch", (Object)SpringSupport.getStringValueAsBoolean((String)partialMatch));
        }
        this.log.debug("SourceValue value: {}, caseSensitive: {}, partialMatch: {}", new Object[]{value, caseSensitive, partialMatch});
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

