/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeSourcedSubjectCanonicalization
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeSourcedSubjectCanonicalization.class);
    private char delimiter = (char)64;
    @Nonnull
    @NonnullElements
    private List<String> attributeSourceIds = Collections.emptyList();
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(SubjectCanonicalizationContext.class));
    @Nullable
    private AttributeContext attributeCtx;

    public void setScopedDelimiter(char ch) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.delimiter = ch;
    }

    public void setAttributeSourceIds(@Nonnull @NonnullElements List<String> ids) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeSourceIds = Lists.newArrayList((Iterable)StringSupport.normalizeStringCollection(ids));
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeSourceIds.isEmpty()) {
            throw new ComponentInitializationException("Attribute source ID list cannot be empty");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        this.attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.attributeCtx == null || this.attributeCtx.getIdPAttributes().isEmpty()) {
            this.log.warn("{} No attributes found, canonicalization not possible", (Object)this.getLogPrefix());
            c14nContext.setException((Exception)new SubjectCanonicalizationException("No attributes were found"));
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            return false;
        }
        return super.doPreExecute(profileRequestContext, c14nContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        for (String id : this.attributeSourceIds) {
            IdPAttribute attr = (IdPAttribute)this.attributeCtx.getIdPAttributes().get(id);
            if (attr == null) continue;
            for (IdPAttributeValue val : attr.getValues()) {
                if (val instanceof StringAttributeValue) {
                    this.log.debug("{} Using attribute {} string value {} as input to transforms", new Object[]{this.getLogPrefix(), id, val.getValue()});
                    c14nContext.setPrincipalName(this.applyTransforms(((StringAttributeValue)val).getValue()));
                    return;
                }
                if (val instanceof ScopedStringAttributeValue) {
                    ScopedStringAttributeValue scoped = (ScopedStringAttributeValue)val;
                    String withScope = scoped.getValue() + this.delimiter + scoped.getScope();
                    this.log.debug("{} Using attribute {} scoped value {} as input to transforms", new Object[]{this.getLogPrefix(), id, withScope});
                    c14nContext.setPrincipalName(this.applyTransforms(withScope));
                    return;
                }
                this.log.warn("{} Unsupported attribute value type: {}", (Object)this.getLogPrefix(), (Object)val.getClass().getName());
            }
        }
        this.log.info("{} Attribute sources {} did not produce a usable identifier", (Object)this.getLogPrefix(), this.attributeSourceIds);
        c14nContext.setException((Exception)new SubjectCanonicalizationException("No usable attribute values were found"));
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
    }
}

