/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AbstractExtractionAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UserAgentContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractUserAgentIdentifier
extends AbstractExtractionAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractUserAgentIdentifier.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            this.log.debug("{} User-Agent header not found in request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        ((UserAgentContext)authenticationContext.getSubcontext(UserAgentContext.class, true)).setIdentifier(this.applyTransforms(agent));
    }
}

