/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.session.context.SessionContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizeAuthentication
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FinalizeAuthentication.class);
    @Nullable
    private String canonicalPrincipalName;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        AuthenticationResult latest;
        Principal match;
        RequestedPrincipalContext requestedPrincipalCtx;
        SessionContext sessionCtx;
        SubjectCanonicalizationContext c14nCtx = (SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class);
        if (c14nCtx != null) {
            this.canonicalPrincipalName = c14nCtx.getPrincipalName();
            profileRequestContext.removeSubcontext((BaseContext)c14nCtx);
            this.log.debug("{} Canonical principal name was established as '{}'", (Object)this.getLogPrefix(), (Object)this.canonicalPrincipalName);
        }
        if (this.canonicalPrincipalName == null && (sessionCtx = (SessionContext)profileRequestContext.getSubcontext(SessionContext.class)) != null && sessionCtx.getIdPSession() != null) {
            this.canonicalPrincipalName = sessionCtx.getIdPSession().getPrincipalName();
            this.log.debug("{} Canonical principal name established from session as '{}'", (Object)this.getLogPrefix(), (Object)this.canonicalPrincipalName);
        }
        if (!((requestedPrincipalCtx = (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class)) == null || (match = requestedPrincipalCtx.getMatchingPrincipal()) == null || (latest = authenticationContext.getAuthenticationResult()) != null && latest.getSupportedPrincipals(match.getClass()).contains(match))) {
            this.log.warn("{} Authentication result for flow {} did not satisfy the requested Principal {}", new Object[]{this.getLogPrefix(), latest != null ? latest.getAuthenticationFlowId() : "(none)", match});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
            return false;
        }
        return super.doPreExecute(profileRequestContext, authenticationContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.canonicalPrincipalName != null) {
            SubjectContext sc = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class, true);
            if (sc.getPrincipalName() != null && !this.canonicalPrincipalName.equals(sc.getPrincipalName())) {
                this.log.warn("{} Result of authentication ({}) does not match existing subject in context ({})", new Object[]{this.getLogPrefix(), this.canonicalPrincipalName, sc.getPrincipalName()});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubjectContext");
                return;
            }
            sc.setPrincipalName(this.canonicalPrincipalName);
            Map scResults = sc.getAuthenticationResults();
            scResults.putAll(authenticationContext.getActiveResults());
            AuthenticationResult latest = authenticationContext.getAuthenticationResult();
            if (latest != null && !scResults.containsKey(latest.getAuthenticationFlowId())) {
                scResults.put(latest.getAuthenticationFlowId(), latest);
            }
        }
        authenticationContext.setCompletionInstant();
    }
}

