/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteUserAuthServlet
extends HttpServlet {
    private static final long serialVersionUID = -3162057736238514851L;
    @Nonnull
    @NotEmpty
    private static final String CHECK_REMOTE_USER_PARAM = "checkRemoteUser";
    @Nonnull
    @NotEmpty
    private static final String CHECK_ATTRIBUTES_PARAM = "checkAttributes";
    @Nonnull
    @NotEmpty
    private static final String CHECK_HEADERS_PARAM = "checkHeaders";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RemoteUserAuthServlet.class);
    private boolean checkRemoteUser = true;
    @Nonnull
    @NonnullElements
    private Collection<String> checkAttributes = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private Collection<String> checkHeaders = Collections.emptyList();

    public void setCheckRemoteUser(boolean flag) {
        this.checkRemoteUser = flag;
    }

    public void setCheckAttributes(@Nonnull @NonnullElements Collection<String> attributes) {
        this.checkAttributes = Lists.newArrayList((Iterable)Collections2.filter(attributes, (Predicate)Predicates.notNull()));
    }

    public void setCheckHeaders(@Nonnull @NonnullElements Collection<String> headers) {
        this.checkHeaders = Lists.newArrayList((Iterable)Collections2.filter(headers, (Predicate)Predicates.notNull()));
    }

    public void init(ServletConfig config) throws ServletException {
        Object[] headers;
        Object[] attrs;
        super.init(config);
        String param = config.getInitParameter(CHECK_REMOTE_USER_PARAM);
        if (param != null) {
            this.checkRemoteUser = Boolean.parseBoolean(param);
        }
        if ((param = config.getInitParameter(CHECK_ATTRIBUTES_PARAM)) != null && (attrs = param.split(" ")) != null) {
            this.checkAttributes = StringSupport.normalizeStringCollection((Collection)Lists.newArrayList((Object[])attrs));
        }
        if ((param = config.getInitParameter(CHECK_HEADERS_PARAM)) != null && (headers = param.split(" ")) != null) {
            this.checkHeaders = StringSupport.normalizeStringCollection((Collection)Lists.newArrayList((Object[])headers));
        }
        this.log.info("RemoteUserAuthServlet {} process REMOTE_USER, along with attributes {} and headers {}", new Object[]{this.checkRemoteUser ? "will" : "will not", this.checkAttributes, this.checkHeaders});
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        try {
            String key = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)httpRequest);
            String username = null;
            if (this.checkRemoteUser && (username = httpRequest.getRemoteUser()) != null && !username.isEmpty()) {
                this.log.debug("User identity extracted from REMOTE_USER: {}", (Object)username);
            }
            if (username == null) {
                for (String s : this.checkAttributes) {
                    Object attr = httpRequest.getAttribute(s);
                    if (attr == null || attr.toString().isEmpty()) continue;
                    username = attr.toString();
                    this.log.debug("User identity extracted from attribute {}: {}", (Object)s, attr);
                    break;
                }
            }
            if (username == null) {
                for (String s : this.checkHeaders) {
                    username = httpRequest.getHeader(s);
                    if (username == null || username.isEmpty()) continue;
                    this.log.debug("User identity extracted from header {}: {}", (Object)s, (Object)username);
                    break;
                }
            }
            if (username != null) {
                httpRequest.setAttribute("principal_name", (Object)username);
            }
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
        catch (ExternalAuthenticationException e) {
            throw new ServletException("Error processing external authentication request", (Throwable)e);
        }
    }
}

