/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateExternalAuthentication
extends AbstractValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateExternalAuthentication.class);
    @Nullable
    private ExternalAuthenticationContext extContext;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.debug("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.extContext = (ExternalAuthenticationContext)authenticationContext.getSubcontext(ExternalAuthenticationContext.class);
        if (this.extContext == null) {
            this.log.debug("{} No ExternalAuthenticationContext available within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.extContext.getAuthnException() != null) {
            this.log.warn("{} External authentication produced exception", (Object)this.getLogPrefix(), (Object)this.extContext.getAuthnException());
            this.handleError(profileRequestContext, authenticationContext, this.extContext.getAuthnException(), "AuthenticationException");
            return;
        }
        if (this.extContext.getAuthnError() != null) {
            this.log.warn("{} External authentication produced error message: {}", (Object)this.getLogPrefix(), (Object)this.extContext.getAuthnError());
            this.handleError(profileRequestContext, authenticationContext, this.extContext.getAuthnError(), "AuthenticationException");
            return;
        }
        if (this.extContext.getSubject() != null) {
            this.log.info("{} External authentication succeeded for Subject: {}", (Object)this.getLogPrefix(), this.extContext.getSubject().getPrincipals());
        } else if (this.extContext.getPrincipal() != null) {
            this.log.info("{} External authentication succeeded for Principal: {}", (Object)this.getLogPrefix(), (Object)this.extContext.getPrincipal());
            this.extContext.setSubject(new Subject(false, Collections.singleton(this.extContext.getPrincipal()), Collections.emptySet(), Collections.emptySet()));
        } else if (this.extContext.getPrincipalName() != null) {
            this.log.info("{} External authentication succeeded for user: {}", (Object)this.getLogPrefix(), (Object)this.extContext.getPrincipalName());
            this.extContext.setSubject(new Subject(false, Collections.singleton(new UsernamePrincipal(this.extContext.getPrincipalName())), Collections.emptySet(), Collections.emptySet()));
        } else {
            this.log.info("{} External authentication failed, no user identity or error information returned", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return;
        }
        if (this.extContext.doNotCache()) {
            this.log.debug("{} Disabling caching of authentication result", (Object)this.getLogPrefix());
            authenticationContext.setResultCacheable(false);
        }
        this.buildAuthenticationResult(profileRequestContext, authenticationContext);
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        this.extContext.getSubject().getPrincipals().addAll(subject.getPrincipals());
        return this.extContext.getSubject();
    }
}

