/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernameContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateRemoteUser
extends AbstractValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateRemoteUser.class);
    @Nonnull
    @NonnullElements
    private Set<String> whitelistedUsernames = Collections.emptySet();
    @Nonnull
    @NonnullElements
    private Set<String> blacklistedUsernames = Collections.emptySet();
    @Nullable
    private Pattern matchExpression;
    @Nullable
    private UsernameContext usernameContext;

    public void setWhitelistedUsernames(@Nonnull @NonnullElements Collection<String> whitelist) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.whitelistedUsernames = Sets.newHashSet((Iterable)StringSupport.normalizeStringCollection(whitelist));
    }

    public void setBlacklistedUsernames(@Nonnull @NonnullElements Collection<String> blacklist) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.blacklistedUsernames = Sets.newHashSet((Iterable)StringSupport.normalizeStringCollection(blacklist));
    }

    public void setMatchExpression(@Nullable Pattern expression) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.matchExpression = expression;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.debug("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.usernameContext = (UsernameContext)authenticationContext.getSubcontext(UsernameContext.class);
        if (this.usernameContext == null) {
            this.log.debug("{} No UsernameContext available within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        if (this.usernameContext.getUsername() == null) {
            this.log.debug("{} No username available within UsernameContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!this.isAuthenticated(this.usernameContext.getUsername())) {
            this.log.debug("{} User '{}' was not valid", (Object)this.getLogPrefix(), (Object)this.usernameContext.getUsername());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        this.log.debug("{} Validated user '{}'", (Object)this.getLogPrefix(), (Object)this.usernameContext.getUsername());
        this.buildAuthenticationResult(profileRequestContext, authenticationContext);
    }

    private boolean isAuthenticated(@Nonnull @NotEmpty String username) {
        if (!this.whitelistedUsernames.isEmpty() && !this.whitelistedUsernames.contains(username)) {
            if (this.matchExpression == null) {
                return false;
            }
            return this.matchExpression.matcher(username).matches();
        }
        return !this.blacklistedUsernames.contains(username) && (this.matchExpression == null || this.matchExpression.matcher(username).matches());
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add((Principal)new UsernamePrincipal(this.usernameContext.getUsername()));
        return subject;
    }
}

