/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.collect.Lists;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUsernamePasswordAgainstJAAS
extends AbstractValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUsernamePasswordAgainstJAAS.class);
    @Nullable
    private UsernamePasswordContext upContext;
    @Nullable
    private String loginConfigType;
    @Nullable
    private Configuration.Parameters loginConfigParameters;
    @Nonnull
    @NonnullElements
    private List<String> loginConfigNames = Collections.singletonList("ShibUserPassAuth");

    @Nullable
    public String getLoginConfigType() {
        return this.loginConfigType;
    }

    public void setLoginConfigType(@Nullable String type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigType = StringSupport.trimOrNull((String)type);
    }

    @Nullable
    public Configuration.Parameters getLoginConfigParameters() {
        return this.loginConfigParameters;
    }

    public void setLoginConfigParameters(@Nullable Configuration.Parameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigParameters = params;
    }

    public void setLoginConfigNames(@Nonnull @NonnullElements @NotEmpty List<String> names) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(names, (String)"Configuration name list cannot be null");
        this.loginConfigNames = Lists.newArrayList((Iterable)StringSupport.normalizeStringCollection(names));
        if (this.loginConfigNames.isEmpty()) {
            throw new ConstraintViolationException("Configuration name list cannot be empty");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.info("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.upContext = (UsernamePasswordContext)authenticationContext.getSubcontext(UsernamePasswordContext.class);
        if (this.upContext == null) {
            this.log.info("{} No UsernamePasswordContext available within authentication context", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.upContext.getUsername() == null) {
            this.log.info("{} No username available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.upContext.getPassword() == null) {
            this.log.info("{} No password available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        for (String loginConfigName : this.loginConfigNames) {
            try {
                this.log.debug("{} Attempting to authenticate user '{}'", (Object)this.getLogPrefix(), (Object)this.upContext.getUsername());
                this.authenticate(loginConfigName);
                this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)this.upContext.getUsername());
                this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
                return;
            }
            catch (LoginException e) {
                this.log.info("{} Login by {} failed", new Object[]{this.getLogPrefix(), this.upContext.getUsername(), e});
                this.handleError(profileRequestContext, authenticationContext, e, "InvalidCredentials");
            }
            catch (Exception e) {
                this.log.warn("{} Login by {} produced exception", new Object[]{this.getLogPrefix(), this.upContext.getUsername(), e});
                this.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
            }
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add((Principal)new UsernamePrincipal(this.upContext.getUsername()));
        return subject;
    }

    private void authenticate(@Nonnull @NotEmpty String loginConfigName) throws LoginException, NoSuchAlgorithmException {
        LoginContext jaasLoginCtx;
        if (this.getLoginConfigType() != null) {
            this.log.debug("{} Using custom JAAS configuration type {} with parameters of type {}", new Object[]{this.getLogPrefix(), this.getLoginConfigType(), this.getLoginConfigParameters().getClass().getName()});
            Configuration loginConfig = Configuration.getInstance(this.getLoginConfigType(), this.getLoginConfigParameters());
            jaasLoginCtx = new LoginContext(loginConfigName, this.getSubject(), new SimpleCallbackHandler(), loginConfig);
        } else {
            this.log.debug("{} Using system JAAS configuration", (Object)this.getLogPrefix());
            jaasLoginCtx = new LoginContext(loginConfigName, this.getSubject(), new SimpleCallbackHandler());
        }
        jaasLoginCtx.login();
    }

    protected class SimpleCallbackHandler
    implements CallbackHandler {
        protected SimpleCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            if (callbacks == null || callbacks.length == 0) {
                return;
            }
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)cb;
                    ncb.setName(ValidateUsernamePasswordAgainstJAAS.this.upContext.getUsername());
                    continue;
                }
                if (!(cb instanceof PasswordCallback)) continue;
                PasswordCallback pcb = (PasswordCallback)cb;
                pcb.setPassword(ValidateUsernamePasswordAgainstJAAS.this.upContext.getPassword().toCharArray());
            }
        }
    }
}

