/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.IOException;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbAsReqBuilder;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class ValidateUsernamePasswordAgainstKerberos
extends AbstractValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUsernamePasswordAgainstKerberos.class);
    private boolean refreshKrb5Config;
    private boolean preserveTicket;
    @Nullable
    private UsernamePasswordContext upContext;
    @Nullable
    private Credentials krbCreds;

    public void setRefreshKrb5Config(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.refreshKrb5Config = flag;
    }

    public void setPreserveTicket(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.preserveTicket = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.debug("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.upContext = (UsernamePasswordContext)authenticationContext.getSubcontext(UsernamePasswordContext.class);
        if (this.upContext == null) {
            this.log.info("{} No UsernamePasswordContext available within authentication context", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.upContext.getUsername() == null) {
            this.log.info("{} No username available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.upContext.getPassword() == null) {
            this.log.info("{} No password available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        try {
            if (this.refreshKrb5Config) {
                Config.refresh();
            }
            PrincipalName pname = new PrincipalName(this.upContext.getUsername(), 1);
            KrbAsReqBuilder reqBuilder = new KrbAsReqBuilder(pname, this.upContext.getPassword().toCharArray());
            this.krbCreds = reqBuilder.action().getCreds();
            reqBuilder.destroy();
            this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)pname.getName());
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        }
        catch (IOException | KrbException e) {
            this.log.warn("{} Login by {} produced exception", new Object[]{this.getLogPrefix(), this.upContext.getUsername(), e});
            this.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add((Principal)new UsernamePrincipal(this.upContext.getUsername()));
        subject.getPrincipals().add(new KerberosPrincipal(this.krbCreds.getClient().getName()));
        if (this.preserveTicket) {
            subject.getPrivateCredentials().add(Krb5Util.credsToTicket(this.krbCreds));
        }
        return subject;
    }
}

