/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.cryptacular.x509.dn.Attribute;
import org.cryptacular.x509.dn.Attributes;
import org.cryptacular.x509.dn.NameReader;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X500SubjectCanonicalization
extends AbstractSubjectCanonicalizationAction {
    private static final String CN_OID = "2.5.4.3";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(X500SubjectCanonicalization.class);
    @Nonnull
    private final ActivationCondition embeddedPredicate = new ActivationCondition();
    @Nonnull
    @NonnullElements
    private List<String> objectIds = Collections.singletonList("2.5.4.3");
    @Nullable
    private X500Principal x500Principal;

    public void setObjectIds(@Nonnull @NonnullElements List<String> ids) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(ids, (String)"OID list cannot be null");
        this.objectIds = Lists.newArrayListWithExpectedSize((int)ids.size());
        this.objectIds.addAll(StringSupport.normalizeStringCollection(ids));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        if (this.embeddedPredicate.apply(profileRequestContext, c14nContext, true)) {
            this.x500Principal = c14nContext.getSubject().getPrincipals(X500Principal.class).iterator().next();
            return super.doPreExecute(profileRequestContext, c14nContext);
        }
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        this.log.debug("{} Searching for RDN to extract from DN: {}", (Object)this.getLogPrefix(), (Object)this.x500Principal.getName());
        Attributes dnAttrs = NameReader.readX500Principal((X500Principal)this.x500Principal);
        for (String oid : this.objectIds) {
            String rdn = this.findRDN(dnAttrs, oid);
            if (rdn == null) continue;
            this.log.debug("{} Extracted RDN with OID {}: {}", new Object[]{this.getLogPrefix(), oid, rdn});
            c14nContext.setPrincipalName(this.applyTransforms(rdn));
            return;
        }
        this.log.warn("{} Unable to extract a suitable RDN from DN: {}", (Object)this.getLogPrefix(), (Object)this.x500Principal.getName());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
    }

    @Nullable
    protected String findRDN(@Nonnull Attributes attributes, @Nonnull @NotEmpty String oid) {
        Iterator i = attributes.backward();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            if (!attr.getType().getOid().equals(oid)) continue;
            return attr.getValue();
        }
        return null;
    }

    public static class ActivationCondition
    implements Predicate<ProfileRequestContext> {
        public boolean apply(@Nullable ProfileRequestContext input) {
            SubjectCanonicalizationContext c14nContext;
            if (input != null && (c14nContext = (SubjectCanonicalizationContext)input.getSubcontext(SubjectCanonicalizationContext.class)) != null) {
                return this.apply(input, c14nContext, false);
            }
            return false;
        }

        public boolean apply(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext, boolean duringAction) {
            Set<X500Principal> usernames = c14nContext.getSubject() != null ? c14nContext.getSubject().getPrincipals(X500Principal.class) : null;
            if (duringAction) {
                if (usernames == null || usernames.isEmpty()) {
                    c14nContext.setException((Exception)new SubjectCanonicalizationException("No X500Principals were found"));
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                    return false;
                }
                if (usernames.size() > 1) {
                    c14nContext.setException((Exception)new SubjectCanonicalizationException("Multiple X500Principals were found"));
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                    return false;
                }
                return true;
            }
            return usernames != null && usernames.size() == 1;
        }
    }
}

