/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFlowsByAttribute
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterFlowsByAttribute.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(AuthenticationContext.class));
    @Nullable
    private String attributeId;
    @Nullable
    private IdPAttribute attribute;

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setAttributeId(@Nullable String id) {
        this.attributeId = StringSupport.trimOrNull((String)id);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext) || this.attributeId == null) {
            return false;
        }
        AttributeContext attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (attributeCtx == null) {
            this.log.debug("{} Request does not contain an AttributeContext, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.attribute = (IdPAttribute)attributeCtx.getIdPAttributes().get(this.attributeId);
        if (this.attribute == null || this.attribute.getValues().isEmpty()) {
            this.log.debug("{} Attribute {} has no values, nothing to do", (Object)this.getLogPrefix(), (Object)this.attributeId);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map potentialFlows = authenticationContext.getPotentialFlows();
        Iterator descriptorItr = potentialFlows.entrySet().iterator();
        while (descriptorItr.hasNext()) {
            AuthenticationFlowDescriptor descriptor = (AuthenticationFlowDescriptor)descriptorItr.next().getValue();
            String match = this.getMatch(descriptor);
            if (match != null) {
                this.log.debug("{} Retaining flow {}, matched custom Principal {}", new Object[]{this.getLogPrefix(), descriptor.getId(), match});
                continue;
            }
            this.log.debug("{} Removing flow {}, Principals did not match any attribute values", (Object)this.getLogPrefix(), (Object)descriptor.getId());
            descriptorItr.remove();
        }
        if (potentialFlows.size() == 0) {
            this.log.info("{} No potential authentication flows remain after filtering", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Potential authentication flows left after filtering: {}", (Object)this.getLogPrefix(), (Object)potentialFlows);
        }
    }

    @Nullable
    private String getMatch(@Nonnull AuthenticationFlowDescriptor flow) {
        for (Principal p : flow.getSupportedPrincipals()) {
            for (IdPAttributeValue val : this.attribute.getValues()) {
                if (!(val instanceof StringAttributeValue) || !val.getValue().equals(p.getName())) continue;
                return p.getName();
            }
        }
        return null;
    }
}

