/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.config.navigate.AuthenticationFlowsLookupFunction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactoryRegistry;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateAuthenticationContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateAuthenticationContext.class);
    @Nonnull
    @NonnullElements
    private Collection<AuthenticationFlowDescriptor> availableFlows = Lists.newArrayList();
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> activeFlowsLookupStrategy = new AuthenticationFlowsLookupFunction();
    @Nullable
    private PrincipalEvalPredicateFactoryRegistry evalRegistry;

    PopulateAuthenticationContext() {
    }

    public void setAvailableFlows(@Nonnull @NonnullElements Collection<AuthenticationFlowDescriptor> flows) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(flows, (String)"Flow collection cannot be null");
        this.availableFlows.clear();
        this.availableFlows.addAll(Collections2.filter(flows, (Predicate)Predicates.notNull()));
    }

    public void setActiveFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activeFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Flow lookup strategy cannot be null");
    }

    @Nonnull
    public PrincipalEvalPredicateFactoryRegistry getPrincipalPredicateFactoryEvalRegistry() {
        return this.evalRegistry;
    }

    public void setPrincipalEvalPredicateFactoryRegistry(@Nonnull PrincipalEvalPredicateFactoryRegistry registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.evalRegistry = (PrincipalEvalPredicateFactoryRegistry)Constraint.isNotNull((Object)registry, (String)"PrincipalEvalPredicateFactoryRegistry cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Collection activeFlows;
        if (this.evalRegistry != null) {
            this.log.debug("{} Installing custom PrincipalEvalPredicateFactoryRegistry into AuthenticationContext", (Object)this.getLogPrefix());
            authenticationContext.setPrincipalEvalPredicateFactoryRegistry(this.evalRegistry);
        }
        if ((activeFlows = (Collection)this.activeFlowsLookupStrategy.apply((Object)profileRequestContext)) != null && !activeFlows.isEmpty()) {
            for (AuthenticationFlowDescriptor desc : this.availableFlows) {
                String flowId = desc.getId().substring(desc.getId().indexOf(47) + 1);
                if (activeFlows.contains(flowId)) {
                    if (desc.apply(profileRequestContext)) {
                        authenticationContext.getPotentialFlows().put(desc.getId(), desc);
                        continue;
                    }
                    this.log.debug("{} Filtered out authentication flow {} due to attached condition", (Object)this.getLogPrefix(), (Object)desc.getId());
                    continue;
                }
                this.log.debug("{} Filtered out authentication flow {} due to profile configuration", (Object)this.getLogPrefix(), (Object)desc.getId());
            }
        } else {
            for (AuthenticationFlowDescriptor desc : this.availableFlows) {
                if (desc.apply(profileRequestContext)) {
                    authenticationContext.getPotentialFlows().put(desc.getId(), desc);
                    continue;
                }
                this.log.debug("{} Filtered out authentication flow {} due to attached condition", (Object)this.getLogPrefix(), (Object)desc.getId());
            }
        }
        this.log.debug("{} Installed {} authentication flows into AuthenticationContext", (Object)this.getLogPrefix(), (Object)authenticationContext.getPotentialFlows().size());
    }
}

