/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.LDAPResponseContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.ldaptive.Credential;
import org.ldaptive.LdapException;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.jaas.LdapPrincipal;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUsernamePasswordAgainstLDAP
extends AbstractValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUsernamePasswordAgainstLDAP.class);
    @Nullable
    private UsernamePasswordContext upContext;
    @Nonnull
    private Authenticator authenticator;
    @Nullable
    private String[] returnAttributes;
    @Nullable
    private AuthenticationResponse response;

    @NonnullAfterInit
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(@Nonnull Authenticator auth) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authenticator = (Authenticator)Constraint.isNotNull((Object)auth, (String)"Authenticator cannot be null");
    }

    @Nullable
    public String[] getReturnAttributes() {
        return this.returnAttributes;
    }

    public void setReturnAttributes(String ... attributes) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.returnAttributes = attributes;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.authenticator == null) {
            throw new ComponentInitializationException("Authenticator cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.debug("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.upContext = (UsernamePasswordContext)authenticationContext.getSubcontext(UsernamePasswordContext.class);
        if (this.upContext == null) {
            this.log.info("{} No UsernamePasswordContext available within authentication context", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.upContext.getUsername() == null) {
            this.log.info("{} No username available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.upContext.getPassword() == null) {
            this.log.info("{} No password available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        try {
            this.log.debug("{} Attempting to authenticate user {}", (Object)this.getLogPrefix(), (Object)this.upContext.getUsername());
            AuthenticationRequest request = new AuthenticationRequest(this.upContext.getUsername(), new Credential(this.upContext.getPassword()), this.returnAttributes);
            this.response = this.authenticator.authenticate(request);
            this.log.trace("{} Authentication response {}", (Object)this.getLogPrefix(), (Object)this.response);
            if (((Boolean)this.response.getResult()).booleanValue()) {
                this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)this.upContext.getUsername());
                ((LDAPResponseContext)authenticationContext.getSubcontext(LDAPResponseContext.class, true)).setAuthenticationResponse(this.response);
                if (this.response.getAccountState() != null) {
                    this.handleWarning(profileRequestContext, authenticationContext, String.format("%s:%s:%s", "ACCOUNT_WARNING", this.response.getResultCode(), this.response.getMessage()), "AccountWarning");
                }
                this.buildAuthenticationResult(profileRequestContext, authenticationContext);
            } else {
                this.log.info("{} Login by '{}' failed", (Object)this.getLogPrefix(), (Object)this.upContext.getUsername());
                ((LDAPResponseContext)authenticationContext.getSubcontext(LDAPResponseContext.class, true)).setAuthenticationResponse(this.response);
                if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == this.response.getAuthenticationResultCode() || AuthenticationResultCode.INVALID_CREDENTIAL == this.response.getAuthenticationResultCode()) {
                    this.handleError(profileRequestContext, authenticationContext, String.format("%s:%s", this.response.getAuthenticationResultCode(), this.response.getMessage()), "InvalidCredentials");
                } else if (this.response.getAccountState() != null) {
                    AccountState state = this.response.getAccountState();
                    this.handleError(profileRequestContext, authenticationContext, String.format("%s:%s:%s", state.getError(), this.response.getResultCode(), this.response.getMessage()), "AccountError");
                } else {
                    this.handleError(profileRequestContext, authenticationContext, String.format("%s:%s", this.response.getResultCode(), this.response.getMessage()), "InvalidCredentials");
                }
            }
        }
        catch (LdapException e) {
            this.log.warn("{} Login by {} produced exception", new Object[]{this.getLogPrefix(), this.upContext.getUsername(), e});
            this.handleError(profileRequestContext, authenticationContext, (Exception)((Object)e), "AuthenticationException");
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add((Principal)new UsernamePrincipal(this.upContext.getUsername()));
        subject.getPrincipals().add((Principal)new LdapPrincipal(this.upContext.getUsername(), this.response.getLdapEntry()));
        return subject;
    }
}

