/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class X509AuthServlet
extends HttpServlet {
    private static final long serialVersionUID = 7466474175700654990L;
    @Nonnull
    @NotEmpty
    private static final String TRUST_ENGINE_PARAM = "trustEngine";
    @Nonnull
    @NotEmpty
    private static final String PASSTHROUGH_PARAM = "x509passthrough";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(X509AuthServlet.class);
    @Nullable
    private TrustEngine<X509Credential> trustEngine;

    public void setTrustEngine(@Nullable TrustEngine<X509Credential> tm) {
        this.trustEngine = tm;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WebApplicationContext springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        String param = config.getInitParameter(TRUST_ENGINE_PARAM);
        if (param != null) {
            this.log.debug("Looking up TrustEngine bean: {}", (Object)param);
            Object bean = springContext.getBean(param);
            if (bean instanceof TrustEngine) {
                this.trustEngine = (TrustEngine)bean;
            } else {
                throw new ServletException("Bean " + param + " was missing, or not a TrustManager");
            }
        }
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        try {
            String passthrough;
            String key = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)httpRequest);
            X509Certificate[] certs = (X509Certificate[])httpRequest.getAttribute("javax.servlet.request.X509Certificate");
            this.log.debug("{} X.509 Certificate(s) found in request", (Object)(certs != null ? certs.length : 0));
            if (certs == null || certs.length < 1) {
                this.log.error("No X.509 Certificates found in request");
                httpRequest.setAttribute("authnError", (Object)"NoCredentials");
                ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                return;
            }
            X509Certificate cert = certs[0];
            this.log.debug("End-entity X.509 certificate found with subject '{}', issued by '{}'", (Object)cert.getSubjectDN().getName(), (Object)cert.getIssuerDN().getName());
            if (this.trustEngine != null) {
                try {
                    BasicX509Credential cred = new BasicX509Credential(cert);
                    cred.setEntityCertificateChain(Arrays.asList(certs));
                    if (!this.trustEngine.validate((Object)cred, new CriteriaSet())) {
                        this.log.warn("Trust engine failed to validate X.509 certificate");
                        httpRequest.setAttribute("authnError", (Object)"InvalidCredentials");
                        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                        return;
                    }
                    this.log.debug("Trust engine validated X.509 certificate");
                }
                catch (SecurityException e) {
                    this.log.error("Exception raised by trust engine", (Throwable)e);
                    httpRequest.setAttribute("authnException", (Object)e);
                    ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                    return;
                }
            }
            if ((passthrough = httpRequest.getParameter(PASSTHROUGH_PARAM)) != null && Boolean.parseBoolean(passthrough)) {
                this.log.debug("Setting UI passthrough cookie");
                Cookie cookie = new Cookie(PASSTHROUGH_PARAM, "1");
                cookie.setPath(httpRequest.getContextPath());
                cookie.setMaxAge(31536000);
                cookie.setSecure(true);
                httpResponse.addCookie(cookie);
            }
            Subject subject = new Subject();
            subject.getPublicCredentials().add(cert);
            subject.getPrincipals().add(cert.getSubjectX500Principal());
            httpRequest.setAttribute("subject", (Object)subject);
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
        catch (ExternalAuthenticationException e) {
            throw new ServletException("Error processing external authentication request", (Throwable)e);
        }
    }
}

