/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo.impl;

import com.duosecurity.duoweb.Base64;
import com.duosecurity.duoweb.DuoWeb;
import com.duosecurity.duoweb.DuoWebException;
import com.duosecurity.duoweb.Util;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DuoSupport {
    public static final DateTimeFormatter RFC_2822_DATE_FORMAT = DateTimeFormat.forPattern((String)"EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z");

    private DuoSupport() {
    }

    @Nonnull
    @NotEmpty
    public static String generateSignedRequestToken(@Nonnull DuoIntegration duo, @Nonnull @NotEmpty String username) throws DuoWebException {
        String signedRequestToken = username == null ? "ERR|The username passed to sign_request() is invalid." : DuoWeb.signRequest((String)duo.getIntegrationKey(), (String)duo.getSecretKey(), (String)duo.getApplicationKey(), (String)username);
        if (signedRequestToken.startsWith("ERR|")) {
            throw new DuoWebException(signedRequestToken);
        }
        return signedRequestToken;
    }

    @Nonnull
    @NotEmpty
    public static String validateSignedResponseToken(@Nonnull DuoIntegration duo, @Nonnull @NotEmpty String signedResponseToken) throws DuoWebException, InvalidKeyException, IOException, NoSuchAlgorithmException {
        try {
            String username = DuoWeb.verifyResponse((String)duo.getIntegrationKey(), (String)duo.getSecretKey(), (String)duo.getApplicationKey(), (String)signedResponseToken);
            return username;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DuoWebException(e.getMessage());
        }
    }

    @Nonnull
    @NotEmpty
    public static void signRequest(@Nonnull RequestBuilder request, @Nonnull DuoIntegration duo) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        String ikey = duo.getIntegrationKey();
        String skey = duo.getSecretKey();
        int sigVersion = 2;
        String date = new DateTime().toString(RFC_2822_DATE_FORMAT);
        String canon = DuoSupport.canonRequest(request, date, 2);
        String sig = Util.hmacSign((String)skey, (String)canon);
        String auth = ikey + ":" + sig;
        String header = "Basic " + Base64.encodeBytes((byte[])auth.getBytes());
        request.addHeader("Authorization", header);
        request.addHeader("Date", date);
    }

    private static String canonRequest(@Nonnull RequestBuilder request, @Nonnull String date, int sigVersion) throws UnsupportedEncodingException {
        URI uri = request.getUri();
        String canon = "";
        if (sigVersion == 2) {
            canon = canon + date + "\n";
        }
        canon = canon + request.getMethod().toUpperCase() + "\n";
        canon = canon + uri.getHost().toLowerCase() + "\n";
        canon = canon + uri.getPath() + "\n";
        canon = canon + DuoSupport.createQueryString(request.getParameters());
        return canon;
    }

    private static String createQueryString(@Nonnull List<NameValuePair> params) throws UnsupportedEncodingException {
        ArrayList<String> args = new ArrayList<String>();
        Collections.sort(params, new Comparator<NameValuePair>(){

            @Override
            public int compare(NameValuePair nvp1, NameValuePair nvp2) {
                return nvp1.getName().compareTo(nvp2.getName());
            }
        });
        Escaper escaper = UrlEscapers.urlFormParameterEscaper();
        for (NameValuePair nvp : params) {
            String name = escaper.escape(nvp.getName()).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            String value = escaper.escape(nvp.getValue()).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            args.add(name + "=" + value);
        }
        return StringSupport.listToStringValue(args, (String)"&");
    }
}

