/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo.impl;

import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.duo.context.DuoAuthenticationContext;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractDuoAuthenticationFromHeaders<InboundMessageType, OutboundMessageType>
extends AbstractAuthenticationAction<InboundMessageType, OutboundMessageType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractDuoAuthenticationFromHeaders.class);
    private boolean autoAuthenticationSupported = true;
    private boolean clientAddressTrusted = true;
    @Nonnull
    @NotEmpty
    private String factorHeaderName = "X-Shibboleth-Duo-Factor";
    @Nonnull
    @NotEmpty
    private String deviceHeaderName = "X-Shibboleth-Duo-Device";
    @Nonnull
    @NotEmpty
    private String passcodeHeaderName = "X-Shibboleth-Duo-Passcode";
    @Nullable
    private Function<ProfileRequestContext, Map<String, String>> pushInfoLookupStrategy;

    ExtractDuoAuthenticationFromHeaders() {
    }

    public void setFactorHeader(@Nonnull @NotEmpty String headerName) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.factorHeaderName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)headerName), (String)"Factor header name cannot be null or empty.");
    }

    public void setDeviceHeader(@Nonnull @NotEmpty String headerName) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deviceHeaderName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)headerName), (String)"Device header name cannot be null or empty.");
    }

    public void setPasscodeHeader(@Nonnull @NotEmpty String headerName) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.passcodeHeaderName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)headerName), (String)"Passcode header name cannot be null or empty.");
    }

    public boolean isClientAddressTrusted() {
        return this.clientAddressTrusted;
    }

    public void setClientAdddressTrusted(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientAddressTrusted = flag;
    }

    public boolean isAutoAuthenticationSupported() {
        return this.autoAuthenticationSupported;
    }

    public void setAutoAuthenticationSupported(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.autoAuthenticationSupported = flag;
    }

    public void setPushInfoLookupStrategy(@Nullable Function<ProfileRequestContext, Map<String, String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.pushInfoLookupStrategy = strategy;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        DuoAuthenticationContext duoCtx;
        block12: {
            this.log.debug("{} Checking for Duo authentication headers", (Object)this.getLogPrefix());
            duoCtx = new DuoAuthenticationContext();
            this.extractHeaders(duoCtx);
            if (duoCtx.getFactor() == null) {
                if (this.autoAuthenticationSupported && !profileRequestContext.isBrowserProfile()) {
                    this.log.debug("{} Non-browser request with no Duo factor specified, enabling auto method", (Object)this.getLogPrefix());
                    duoCtx.setFactor("auto");
                    break block12;
                } else {
                    this.log.debug("{} No Duo factor specified, auto method will not be attempted", (Object)this.getLogPrefix());
                    ActionSupport.buildEvent(profileRequestContext, (String)"NoCredentials");
                    return;
                }
            }
            if ("sms".equals(duoCtx.getFactor())) {
                this.log.warn("{} Request for SMS codes unsupported", (Object)this.getLogPrefix());
                ActionSupport.buildEvent(profileRequestContext, (String)"NoCredentials");
                return;
            }
        }
        if ("passcode".equals(duoCtx.getFactor())) {
            if (duoCtx.getPasscode() == null) {
                this.log.warn("{} Request for passcode-based Duo login with no password supplied", (Object)this.getLogPrefix());
                ActionSupport.buildEvent(profileRequestContext, (String)"NoCredentials");
                return;
            }
        } else if (this.autoAuthenticationSupported && duoCtx.getDeviceID() == null) {
            duoCtx.setDeviceID("auto");
        }
        if (this.pushInfoLookupStrategy != null) {
            Map pushinfo = (Map)this.pushInfoLookupStrategy.apply(profileRequestContext);
            if (pushinfo != null) {
                duoCtx.getPushInfo().putAll(pushinfo);
            }
        } else {
            String name;
            RelyingPartyUIContext uiCtx = (RelyingPartyUIContext)authenticationContext.getSubcontext(RelyingPartyUIContext.class);
            if (uiCtx != null && (name = uiCtx.getServiceName()) != null) {
                duoCtx.getPushInfo().put("service", uiCtx.getServiceName());
            }
        }
        authenticationContext.addSubcontext((BaseContext)duoCtx, true);
        this.log.debug("{} Duo AuthAPI parameters extracted from request (Factor: {}, Device: {}, Passcode: {})", new Object[]{this.getLogPrefix(), duoCtx.getFactor(), duoCtx.getDeviceID(), duoCtx.getPasscode() != null ? "set" : "not set"});
    }

    protected void extractHeaders(@Nonnull DuoAuthenticationContext context) {
        String passcode;
        String device;
        String factor;
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        if (httpRequest == null) {
            return;
        }
        if (this.clientAddressTrusted) {
            context.setClientAddress(httpRequest.getRemoteAddr());
        }
        if ((factor = httpRequest.getHeader(this.factorHeaderName)) != null && !factor.isEmpty()) {
            context.setFactor(factor);
        }
        if ((device = httpRequest.getHeader(this.deviceHeaderName)) != null && !device.isEmpty()) {
            context.setDeviceID(device);
        }
        if ((passcode = httpRequest.getHeader(this.passcodeHeaderName)) != null && !passcode.isEmpty()) {
            context.setPasscode(passcode);
        }
    }
}

