/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo.impl;

import com.duosecurity.duoweb.DuoWebException;
import com.google.common.base.Function;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.idp.authn.duo.DuoPrincipal;
import net.shibboleth.idp.authn.duo.context.DuoAuthenticationContext;
import net.shibboleth.idp.authn.duo.impl.DuoAuthAuthenticator;
import net.shibboleth.idp.authn.duo.impl.DuoAuthResponse;
import net.shibboleth.idp.authn.duo.impl.DuoDevice;
import net.shibboleth.idp.authn.duo.impl.DuoPreauthAuthenticator;
import net.shibboleth.idp.authn.duo.impl.DuoPreauthResponse;
import net.shibboleth.idp.session.context.navigate.CanonicalUsernameLookupStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDuoAuthAPI
extends AbstractValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.duo";
    @Nonnull
    @NotEmpty
    private final Logger log = LoggerFactory.getLogger(ValidateDuoAuthAPI.class);
    @Nonnull
    private Function<ProfileRequestContext, DuoIntegration> duoIntegrationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy = new CanonicalUsernameLookupStrategy();
    @Nonnull
    private DuoAuthAuthenticator authAuthenticator;
    @Nonnull
    private DuoPreauthAuthenticator preauthAuthenticator;
    @Nonnull
    @NotEmpty
    private DuoAuthenticationContext duoContext;
    @Nullable
    private DuoIntegration duoIntegration;
    @Nullable
    @NotEmpty
    private String username;

    public ValidateDuoAuthAPI() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    public void setDuoIntegrationLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoIntegration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.duoIntegrationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoIntegration lookup strategy cannot be null");
    }

    public void setDuoIntegration(@Nonnull DuoIntegration duo) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)duo, (String)"DuoIntegration cannot be null");
        this.duoIntegrationLookupStrategy = FunctionSupport.constant((Object)duo);
    }

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    public void setAuthAuthenticator(@Nonnull DuoAuthAuthenticator authenticator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authAuthenticator = (DuoAuthAuthenticator)((Object)Constraint.isNotNull((Object)((Object)authenticator), (String)"DuoAuthAuthenticator cannot be null"));
    }

    public void setPreauthAuthenticator(@Nonnull DuoPreauthAuthenticator authenticator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.preauthAuthenticator = (DuoPreauthAuthenticator)((Object)Constraint.isNotNull((Object)((Object)authenticator), (String)"DuoPreauthAuthenticator cannot be null"));
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.authAuthenticator == null) {
            throw new ComponentInitializationException("DuoAuthAuthenticator cannot be null");
        }
        if (this.preauthAuthenticator == null) {
            throw new ComponentInitializationException("DuoPreauthAuthenticator cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.duoIntegration = (DuoIntegration)this.duoIntegrationLookupStrategy.apply((Object)profileRequestContext);
        if (this.duoIntegration == null) {
            this.log.warn("{} No DuoIntegration returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.username = (String)this.usernameLookupStrategy.apply((Object)profileRequestContext);
        if (this.username == null) {
            this.log.warn("{} No principal name available to cross-check Duo result", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        this.duoContext = (DuoAuthenticationContext)authenticationContext.getSubcontext(DuoAuthenticationContext.class);
        if (this.duoContext == null) {
            this.log.info("{} No DuoAuthenticationContext available", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "No DuoAuthenticationContext context available", "InvalidAuthenticationContext");
            this.recordFailure();
            return false;
        }
        if (this.duoContext.getFactor() == null) {
            this.log.info("{} No factor set in DuoAuthenticationContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "No Duo factor set in DuoAuthenticationContext", "RequestUnsupported");
            this.recordFailure();
            return false;
        }
        this.duoContext.setUsername(this.username);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        block12: {
            this.log.trace("{} Attempting Duo AuthAPI authentication", (Object)this.getLogPrefix());
            try {
                DuoAuthResponse authenticationResponse;
                DuoPreauthResponse preAuthResponse = this.preauthAuthenticator.authenticate(this.duoContext, this.duoIntegration);
                if (preAuthResponse == null) {
                    this.log.info("{} No Duo AuthAPI preauthentication response", (Object)this.getLogPrefix());
                    throw new DuoWebException("No preauthentication response");
                }
                String preAuthResult = preAuthResponse.getResult();
                if ("allow".equals(preAuthResult)) {
                    this.log.info("{} Duo pre-authentication (bypass) succeeded for '{}'", (Object)this.getLogPrefix(), (Object)this.username);
                    this.recordSuccess();
                    this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                    return;
                }
                if (!"auth".equals(preAuthResult)) {
                    this.log.info("{} Duo pre-authentication failed for '{}': {}", new Object[]{this.getLogPrefix(), this.username, preAuthResponse.getStatusMessage()});
                    this.handleError(profileRequestContext, authenticationContext, String.format("%s:%s:%s", preAuthResult, this.username, preAuthResponse.getStatusMessage()), "AccountError");
                    this.recordFailure();
                    return;
                }
                if (this.duoContext.getDeviceID() != null && !"auto".equals(this.duoContext.getDeviceID())) {
                    boolean found = false;
                    for (DuoDevice device : preAuthResponse.getDevices()) {
                        if (this.duoContext.getDeviceID().equals(device.getDevice())) {
                            found = true;
                            break;
                        }
                        if (!this.duoContext.getDeviceID().equals(device.getName())) continue;
                        this.log.debug("{} Remapped device ID based on device name ({}) for '{}'", new Object[]{this.getLogPrefix(), device.getName(), this.username});
                        this.duoContext.setDeviceID(device.getDevice());
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.log.info("{} Duo authentication failed for '{}': non-existent device ID ({})", new Object[]{this.getLogPrefix(), this.username, this.duoContext.getDeviceID()});
                        this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
                        this.recordFailure();
                        return;
                    }
                }
                if ((authenticationResponse = this.authAuthenticator.authenticate(this.duoContext, this.duoIntegration)) == null) {
                    this.log.info("{} No Duo AuthAPI authentication response", (Object)this.getLogPrefix());
                    throw new DuoWebException("No authentication response");
                }
                String authResult = authenticationResponse.getResult();
                if ("allow".equals(authResult)) {
                    this.log.info("{} Duo authentication succeeded for '{}' (Factor: {}, Device: {})", new Object[]{this.getLogPrefix(), this.username, this.duoContext.getFactor(), this.duoContext.getDeviceID()});
                    this.recordSuccess();
                    this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                    break block12;
                }
                if ("deny".equals(authResult)) {
                    this.log.info("{} Duo authentication failed for '{}'", (Object)this.getLogPrefix(), (Object)this.username);
                    this.handleError(profileRequestContext, authenticationContext, authenticationResponse.getStatus(), "InvalidCredentials");
                    this.recordFailure();
                    break block12;
                }
                throw new DuoWebException("Unexpected authentication response");
            }
            catch (DuoWebException e) {
                this.log.error("{} Duo AuthAPI access failed for '{}'", new Object[]{this.getLogPrefix(), this.username, e});
                this.handleError(profileRequestContext, authenticationContext, (Exception)((Object)e), "AuthenticationException");
                this.recordFailure();
            }
        }
    }

    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add((Principal)new DuoPrincipal(this.username));
        subject.getPrincipals().addAll(this.duoIntegration.getSupportedPrincipals(Principal.class));
        return subject;
    }

    protected void buildAuthenticationResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        super.buildAuthenticationResult(profileRequestContext, authenticationContext);
        ((SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class, true)).setPrincipalName(this.username);
    }
}

