/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo.impl;

import com.duosecurity.duoweb.DuoWebException;
import com.google.common.base.Function;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.idp.authn.duo.DuoPrincipal;
import net.shibboleth.idp.authn.duo.impl.DuoSupport;
import net.shibboleth.idp.session.context.navigate.CanonicalUsernameLookupStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDuoWebResponse
extends AbstractValidationAction {
    @Nonnull
    @NotEmpty
    public static final String RESPONSE_PARAM = "sig_response";
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.duo";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateDuoWebResponse.class);
    @Nonnull
    private Function<ProfileRequestContext, DuoIntegration> duoIntegrationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy = new CanonicalUsernameLookupStrategy();
    @Nullable
    private DuoIntegration duoIntegration;
    @Nullable
    @NotEmpty
    private String username;
    @Nullable
    @NotEmpty
    private String signedResponse;

    public ValidateDuoWebResponse() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    public void setDuoIntegrationLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoIntegration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.duoIntegrationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoIntegration lookup strategy cannot be null");
    }

    public void setDuoIntegration(@Nonnull DuoIntegration duo) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)duo, (String)"DuoIntegration cannot be null");
        this.duoIntegrationLookupStrategy = FunctionSupport.constant((Object)duo);
    }

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.duoIntegration = (DuoIntegration)this.duoIntegrationLookupStrategy.apply((Object)profileRequestContext);
        if (this.duoIntegration == null) {
            this.log.warn("{} No DuoIntegration returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.username = (String)this.usernameLookupStrategy.apply((Object)profileRequestContext);
        if (this.username == null) {
            this.log.warn("{} No principal name available to cross-check Duo result", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        HttpServletRequest servletRequest = this.getHttpServletRequest();
        if (servletRequest == null) {
            this.log.error("{} No ServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.signedResponse = servletRequest.getParameter(RESPONSE_PARAM);
        if (this.signedResponse == null || this.signedResponse.isEmpty()) {
            this.log.warn("{} No signed Duo response in the request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            this.recordFailure();
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        String usernameFromDuo;
        this.log.trace("{} Signed Duo response is: {}", (Object)this.getLogPrefix(), (Object)this.signedResponse);
        try {
            usernameFromDuo = DuoSupport.validateSignedResponseToken(this.duoIntegration, this.signedResponse);
        }
        catch (DuoWebException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.log.warn("{} Error validating signed Duo response for username '{}'", new Object[]{this.getLogPrefix(), this.username, e});
            this.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
            this.recordFailure();
            return;
        }
        if (!this.username.equals(usernameFromDuo)) {
            this.log.warn("{} Username '{}' from Duo response does not match previously established username '{}'", new Object[]{this.getLogPrefix(), usernameFromDuo, this.username});
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            this.recordFailure();
        } else {
            this.log.info("{} Duo authentication succeeded for '{}'", (Object)this.getLogPrefix(), (Object)usernameFromDuo);
            this.recordSuccess();
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        }
    }

    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add((Principal)new DuoPrincipal(this.username));
        subject.getPrincipals().addAll(this.duoIntegration.getSupportedPrincipals(Principal.class));
        return subject;
    }

    protected void buildAuthenticationResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        super.buildAuthenticationResult(profileRequestContext, authenticationContext);
        ((SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class, true)).setPrincipalName(this.username);
    }
}

