/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.models.errors.Error;
import com.github.jasminb.jsonapi.models.errors.Errors;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.AccountLockoutManager;
import net.shibboleth.idp.authn.context.LockoutManagerContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.webflow.execution.RequestContext;

public class DoLockoutManagerOperation
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String MANAGER_ID = "lockoutManagerId";
    @Nonnull
    @NotEmpty
    public static final String KEY = "key";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoLockoutManagerOperation.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nullable
    @NotEmpty
    private String managerId;
    @Nullable
    @NotEmpty
    private String key;
    @Nullable
    private AccountLockoutManager lockoutManager;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"ObjectMapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
    }

    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null || this.getHttpServletResponse() == null) {
            this.log.warn("{} No HttpServletRequest or HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        try {
            SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
            if (springRequestContext == null) {
                this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            RequestContext requestContext = springRequestContext.getRequestContext();
            if (requestContext == null) {
                this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            this.lockoutManager = this.getLockoutManager(requestContext);
            if (this.lockoutManager == null) {
                this.sendError(404, "Invalid Lockout Manager", "Invalid lockout manager identifier in path.");
                return false;
            }
            this.key = (String)requestContext.getFlowScope().get(KEY);
            if (Strings.isNullOrEmpty((String)this.key)) {
                this.sendError(404, "Missing Account Key", "No account key specified.");
                return false;
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error issuing API response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        return true;
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        ((LockoutManagerContext)profileRequestContext.getSubcontext(LockoutManagerContext.class, true)).setKey(this.key);
        try {
            HttpServletRequest request = this.getHttpServletRequest();
            HttpServletResponse response = this.getHttpServletResponse();
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            if ("GET".equals(request.getMethod())) {
                try {
                    boolean lockout = this.lockoutManager.check(profileRequestContext);
                    response.setStatus(200);
                    JsonFactory jsonFactory = new JsonFactory();
                    JsonGenerator g = jsonFactory.createGenerator((OutputStream)response.getOutputStream()).useDefaultPrettyPrinter();
                    g.setCodec((ObjectCodec)this.objectMapper);
                    g.writeStartObject();
                    g.writeObjectFieldStart("data");
                    g.writeStringField("type", "lockout-statuses");
                    g.writeStringField("id", this.managerId + '/' + this.key);
                    g.writeObjectFieldStart("attributes");
                    g.writeBooleanField("lockout", lockout);
                    g.close();
                }
                catch (IOException e) {
                    this.sendError(500, "Internal Server Error", "Lockout manager error.");
                }
            } else if ("POST".equals(request.getMethod())) {
                try {
                    if (!this.lockoutManager.increment(profileRequestContext)) {
                        throw new IOException();
                    }
                    response.setStatus(204);
                }
                catch (IOException e) {
                    this.sendError(500, "Internal Server Error", "Lockout manager error.");
                }
            } else if ("DELETE".equals(request.getMethod())) {
                try {
                    if (!this.lockoutManager.clear(profileRequestContext)) {
                        throw new IOException();
                    }
                    response.setStatus(204);
                }
                catch (IOException e) {
                    this.sendError(500, "Internal Server Error", "Lockout manager error.");
                }
            } else {
                this.log.warn("{} Invalid method: {}", (Object)this.getLogPrefix(), (Object)request.getMethod());
                this.sendError(405, "Unknown Operation", "Only GET, POST, and DELETE are supported.");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    @Nullable
    private AccountLockoutManager getLockoutManager(@Nonnull RequestContext requestContext) {
        this.managerId = (String)requestContext.getFlowScope().get(MANAGER_ID);
        if (this.managerId == null) {
            this.log.warn("{} No {} flow variable found in request", (Object)this.getLogPrefix(), (Object)MANAGER_ID);
            return null;
        }
        try {
            Object bean = requestContext.getActiveFlow().getApplicationContext().getBean(this.managerId);
            if (bean != null && bean instanceof AccountLockoutManager) {
                return (AccountLockoutManager)bean;
            }
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        this.log.warn("{} No bean of the correct type found named {}", (Object)this.getLogPrefix(), (Object)this.managerId);
        return null;
    }

    private void sendError(int status, @Nonnull @NotEmpty String title, @Nonnull @NotEmpty String detail) throws IOException {
        HttpServletResponse response = this.getHttpServletResponse();
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        response.setStatus(status);
        Error e = new Error();
        Errors errors = new Errors();
        errors.setErrors(Collections.singletonList(e));
        e.setStatus(Integer.toString(status));
        e.setTitle(title);
        e.setDetail(detail);
        this.objectMapper.writer().withDefaultPrettyPrinter().writeValue((OutputStream)response.getOutputStream(), (Object)errors);
    }
}

