/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizeAuthentication
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FinalizeAuthentication.class);
    @Nonnull
    @NonnullElements
    private Map<Principal, Integer> weightMap = Collections.emptyMap();
    @Nullable
    private String canonicalPrincipalName;

    public void setWeightMap(@Nullable @NonnullElements Map<Principal, Integer> map) {
        if (map == null) {
            this.weightMap = Collections.emptyMap();
            return;
        }
        this.weightMap = new HashMap<Principal, Integer>(map.size());
        for (Map.Entry<Principal, Integer> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.weightMap.put(entry.getKey(), entry.getValue());
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        RequestedPrincipalContext requestedPrincipalCtx;
        SessionContext sessionCtx;
        SubjectCanonicalizationContext c14nCtx = (SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class);
        if (c14nCtx != null) {
            this.canonicalPrincipalName = c14nCtx.getPrincipalName();
            profileRequestContext.removeSubcontext((BaseContext)c14nCtx);
            this.log.debug("{} Canonical principal name was established as '{}'", (Object)this.getLogPrefix(), (Object)this.canonicalPrincipalName);
        }
        if (this.canonicalPrincipalName == null && (sessionCtx = (SessionContext)profileRequestContext.getSubcontext(SessionContext.class)) != null && sessionCtx.getIdPSession() != null) {
            this.canonicalPrincipalName = sessionCtx.getIdPSession().getPrincipalName();
            this.log.debug("{} Canonical principal name established from session as '{}'", (Object)this.getLogPrefix(), (Object)this.canonicalPrincipalName);
        }
        if ((requestedPrincipalCtx = (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class)) != null) {
            AuthenticationResult latest = authenticationContext.getAuthenticationResult();
            if (latest == null) {
                this.log.warn("{} Authentication result missing from context?", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
                return false;
            }
            Principal match = requestedPrincipalCtx.getMatchingPrincipal();
            if (match != null && !latest.getSupportedPrincipals(match.getClass()).contains(match)) {
                this.log.debug("{} Authentication result lacks originally projected matching principal '{}', reevaluating", (Object)this.getLogPrefix(), (Object)match.getName());
                requestedPrincipalCtx.setMatchingPrincipal(null);
            }
            requestedPrincipalCtx.setMatchingPrincipal(this.findMatchingPrincipal(authenticationContext, requestedPrincipalCtx));
            if (requestedPrincipalCtx.getMatchingPrincipal() == null) {
                this.log.warn("{} Authentication result for flow {} did not satisfy the request", (Object)this.getLogPrefix(), (Object)latest.getAuthenticationFlowId());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
                return false;
            }
        } else {
            this.log.debug("{} Request did not have explicit authentication requirements, result is accepted", (Object)this.getLogPrefix());
        }
        return super.doPreExecute(profileRequestContext, authenticationContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.canonicalPrincipalName != null) {
            SubjectContext sc = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class, true);
            if (sc.getPrincipalName() != null && !this.canonicalPrincipalName.equals(sc.getPrincipalName())) {
                this.log.warn("{} Result of authentication ({}) does not match existing subject in context ({})", new Object[]{this.getLogPrefix(), this.canonicalPrincipalName, sc.getPrincipalName()});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubjectContext");
                return;
            }
            sc.setPrincipalName(this.canonicalPrincipalName);
            Map scResults = sc.getAuthenticationResults();
            scResults.putAll(authenticationContext.getActiveResults());
            AuthenticationResult latest = authenticationContext.getAuthenticationResult();
            if (latest != null) {
                scResults.put(latest.getAuthenticationFlowId(), latest);
            }
        }
        authenticationContext.setCompletionInstant();
    }

    @Nullable
    protected Principal findMatchingPrincipal(@Nonnull AuthenticationContext authenticationContext, @Nonnull RequestedPrincipalContext requestedPrincipalCtx) {
        ArrayList<Principal> matches = new ArrayList<Principal>();
        for (Principal p : requestedPrincipalCtx.getRequestedPrincipals()) {
            this.log.debug("{} Checking result for compatibility with operator '{}' and principal '{}'", new Object[]{this.getLogPrefix(), requestedPrincipalCtx.getOperator(), p.getName()});
            PrincipalEvalPredicateFactory factory = requestedPrincipalCtx.getPrincipalEvalPredicateFactoryRegistry().lookup(p.getClass(), requestedPrincipalCtx.getOperator());
            if (factory != null) {
                PrincipalEvalPredicate predicate = factory.getPredicate(p);
                matches.clear();
                for (final Principal candidate : authenticationContext.getAuthenticationResult().getSupportedPrincipals(p.getClass())) {
                    if (!predicate.apply((Object)new PrincipalSupportingComponent(){

                        public <T extends Principal> Set<T> getSupportedPrincipals(Class<T> c) {
                            return Collections.singleton(candidate);
                        }
                    })) continue;
                    this.log.debug("{} Principal '{}' in authentication result satisfies request for principal '{}'", new Object[]{this.getLogPrefix(), candidate.getName(), p.getName()});
                    matches.add(candidate);
                }
                if (matches.isEmpty()) continue;
                break;
            }
            this.log.warn("{} Configuration does not support requested principal evaluation with operator '{}' and type '{}'", new Object[]{this.getLogPrefix(), requestedPrincipalCtx.getOperator(), p.getClass()});
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1 || this.weightMap.isEmpty()) {
            return (Principal)matches.get(0);
        }
        Object[] principalArray = matches.toArray();
        Arrays.sort(principalArray, new WeightedComparator());
        return (Principal)principalArray[principalArray.length - 1];
    }

    private class WeightedComparator
    implements Comparator {
        private WeightedComparator() {
        }

        public int compare(Object o1, Object o2) {
            int weight2;
            int weight1 = FinalizeAuthentication.this.weightMap.containsKey(o1) ? (Integer)FinalizeAuthentication.this.weightMap.get(o1) : 0;
            int n = weight2 = FinalizeAuthentication.this.weightMap.containsKey(o2) ? (Integer)FinalizeAuthentication.this.weightMap.get(o2) : 0;
            if (weight1 < weight2) {
                return -1;
            }
            if (weight1 > weight2) {
                return 1;
            }
            return 0;
        }
    }
}

